% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{run_RNAfold}
\alias{run_RNAfold}
\title{Obtain the Secondary Structure Sequences Using RNAfold}
\usage{
run_RNAfold(Sequences, RNAfold.path = "RNAfold", parallel.cores = 2)
}
\arguments{
\item{Sequences}{A FASTA file loaded by function \code{\link{read.fasta}} of
package "seqinr" (\code{\link[seqinr]{seqinr-package}}).}

\item{RNAfold.path}{String. Indicate the path of the program "RNAfold". By
default is \code{"RNAfold"} for UNIX/Linux system. (See details.)}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}, users can set as \code{-1} to run
this function with all cores.}
}
\value{
Returns data.frame. The first row is RNA sequence; the second row is
Dot-Bracket Notation of secondary structure sequences; the last row is minimum
free energy (MFE).
}
\description{
This function can compute secondary structure sequences. The tool
"RNAfold" of software "ViennaRNA" is required for this function.
}
\details{
This function is used to compute secondary structure. The output of
this function can be used in function \code{\link{make_frequencies}},
\code{\link{extract_features}}, \code{\link{build_model}} and
\code{\link{lnc_finder}} when parameter \code{SS.features} is set as \code{TRUE}.

This function depends on the program "RNAfold" of software "ViennaRNA".
(\url{http://www.tbi.univie.ac.at/RNA/index.html})

Parameter \code{RNAfold.path} can be simply defined as \code{"RNAfold"} as
default when the OS is UNIX/Linux. However, for some OS, such as Windows, users
need to specify the \code{RNAfold.path} if the path of "RNAfold" haven't been
added in environment variables.

This function can print the related information when the OS is UNIX/Linux,
such as:

\code{"25 of 100, length: 695 nt"},

which means around 100 sequences are assigned to this node and the program is
computing the 25th sequence. The length of this sequence is 695nt.
}
\examples{
\dontrun{
### For a FASTA file contains several sequences,
### Use "read.fasta" function of package "seqinr" to read a FASTA file:
Seqs <- read.fasta(file =
"http://www.ncbi.nlm.nih.gov/WebSub/html/help/sample_files/nucleotide-sample.txt")

### Or just try to use our data "demo_DNA.seq"
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

### Windows:
RNAfold.path <- '"E:/Program Files/ViennaRNA/RNAfold.exe"'
SS.seq_1 <- run_RNAfold(Seqs, RNAfold.path = RNAfold.path, parallel.cores = 2)

### For UNIX/Linux, "RNAfold.path" can be just defined as "RNAfold" as default:
SS.seq_2 <- run_RNAfold(Seqs, RNAfold.path = "RNAfold", parallel.cores = 2)
}
}
\author{
Han Siyu
}
