% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistrOvipos.R
\name{plotDistrOvipos}
\alias{plotDistrOvipos}
\title{Plot for Distribution of Age at Oviposition}
\usage{
plotDistrOvipos(
  ColumnFemale,
  ColumnAge,
  ColumnEggs,
  ColumnGroups,
  data,
  InitiationOfAdultStage = 0
)
}
\arguments{
\item{ColumnFemale}{Data vector containing information on Females.}

\item{ColumnAge}{Data vector containing information on Age.}

\item{ColumnEggs}{Data vector containing information on the Number of Eggs Laid.}

\item{ColumnGroups}{Optional data vector containing information on the Groups.
It is optional if the database only contains information about one group.}

\item{data}{An optional data frame containing the variables. If not found in
\code{data}, the variables are taken from environment.}

\item{InitiationOfAdultStage}{Age at which females became adults.
If the database contains records from birth, entering this value is
unnecessary. ONLY ENTER THIS VALUE if the database begins from the adult
stage, and the values in \code{ColumnAge} do not reflect the preceding
stage (i.e. they contain the ages: 1, 2, 3, ...).}
}
\value{
Returns an object of \code{\link[base:class]{class}} c("gg", "ggplot").
}
\description{
This function generates a plot illustrating the Distribution of Oviposition (y-axis)
versus Age (x-axis), with separate representations for each group if multiple groups exist.
The data is sourced from the original database.
}
\examples{
## The Insects database will be used to generate the plot.

plotDistrOvipos(Female, Age, Eggs, Group, data = Insects)

## The following expression will yield the same result as described above:

plotDistrOvipos(Insects$Female, Insects$Age, Insects$Eggs, Insects$Group)


}
