% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomoCoord.R
\name{nomoCoord}
\alias{nomoCoord}
\title{Find the Coordinate from the Scale of a Nomograph}
\usage{
nomoCoord(df, val)
}
\arguments{
\item{df}{A data frame with three columns, the \code{x} and \code{y} coordinates
of the nomograph scale and the corresponding values.}

\item{val}{A numeric scalar identifying the point on the scale for which the
coordinates will be returned.}
}
\value{
A numeric vector of length two with the x and y coordinates of the
  specified point in plotting units of the nomograph.
}
\description{
Find the x and y coordinate corresponding to a specified point on a
nomograph scale.
}
\details{
The function makes it easier to add points or lines to a nomograph for
illustrative purposes.

Each scale is assumed to be displayed on the log10 scale.
}
\examples{
scales <- LWnomo1(TRUE)
fromxy <- nomoCoord(scales$scale1r, 34)
toxy <- nomoCoord(scales$scale3, 16^2/(100*34))
segments(fromxy[1], fromxy[2], toxy[1], toxy[2], col="red")

}

