% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invprobit.R
\name{invprobit}
\alias{invprobit}
\title{Convert Probit Scale to Proportions}
\usage{
invprobit(quan)
}
\arguments{
\item{quan}{A numeric vector of probit quantiles.}
}
\value{
A numeric vector of proportions the same length as \code{quan}.
}
\description{
Convert values on the probit scale to their proportions on the 0 to 1 scale.
}
\details{
Simply calls \code{\link{pnorm}(quan)}.
}
\examples{
invprobit(c(-3, -1, 0, 1, 3))
}

