% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefprobit.R
\name{coefprobit}
\alias{coefprobit}
\title{Calculate the Coefficients of a Probit Regression Fit}
\usage{
coefprobit(pfit, alpha = 0.05)
}
\arguments{
\item{pfit}{An object of class \code{\link{glm}} representing a probit regression fit
to dose-effect data, typically the result of a call to
\code{\link{fitprobit}}.  Dose should be the only independent variable
in the model.}

\item{alpha}{A numeric scalar, the significance level used to generate
100*(1 - \code{alpha})\% confidence limits, default 0.05.}
}
\value{
A numeric vector of length six, the intercept and slope of the
    dose-response curve, each with 100*(1 - \code{alpha})\%
    confidence limits.
}
\description{
Calculate the coefficients from a fitted probit regression model with
  confidence intervals.
}
\examples{
toxdat <- data.frame(
 dose=c(0.05, 0.0625, 0.125, 0.25, 0.5, 1),
 ntot=rep(8, 6),
  nfx = c(0, 1, 4, 4, 6, 8))
myfit <- fitprobit(toxdat)
coefprobit(myfit)
}

