% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessfit.R
\name{assessfit}
\alias{assessfit}
\title{Assess Fit of Dose-Response Curve}
\usage{
assessfit(params, DEdata, fit = gamtable1(), simple = TRUE)
}
\arguments{
\item{params}{A numeric vector of length two, with the estimated intercept
and slope of the dose-effect relation on the log10 and probit scale.
These parameters define the dose-response curve.}

\item{DEdata}{A data frame of dose-effect data (typically, the output from
\code{\link{dataprep}}) containing at least these four variables: dose,
ntot, pfx, fxcateg.}

\item{fit}{A model object that can be used to predict the corrected values
(as proportions) from \code{distexpprop5}, the distance between the
expected values (as proportions) and 0.5, default \code{\link{gamtable1}()}.}

\item{simple}{A logical scalar indicating if the output should be restricted to
just the P value, default TRUE.}
}
\value{
If \code{simple=FALSE}, a list of length two.  The first element,
  \code{chi}, is a numeric vector of length three:
    \code{chistat}, chi-squared statistic;
    \code{df}, degrees of freedom; and
    \code{pval}, P value.
  The second element,
  \code{contrib}, is a matrix of three numeric vectors the same length as
    \code{obsn}:
    \code{exp}, expected effects;
    \code{obscorr}, observed effects corrected; and
    \code{contrib}, contributions to the chi-squared.

 If \code{simple=TRUE}, a numeric scalar, the chi-squared statistic
   (see details).
}
\description{
Assess the fit of a dose-response curve using the chi-squared statistic.
  The curve is described by the intercept and slope of a straight line in
  the log dose vs. probit effect scale.
}
\details{
This function is used to find the dose-response curve that minimizes the
  chi-squared statistic measuring the distance between the observed and
  expected values of the response (the proportion affected).
   Following Litchfield and Wilcoxon (1949, steps B1 and B2),
  records with expected effects < 0.01\% or > 99.99\% are deleted, and
  other expected effects are "corrected" using the
  \code{\link{correctval}} function.
}
\examples{
conc <- c(0.0625, 0.125, 0.25, 0.5, 1)
numtested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=conc, ntot=numtested, nfx=nalive)
gamfit <- gamtable1()
assessfit(log10(c(0.125, 0.5)), mydat, simple=FALSE)
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}
\seealso{
\code{\link{LWchi2}} and \code{\link{chisq.test}}.
}

