% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWnomo1.R
\name{LWnomo1}
\alias{LWnomo1}
\title{Recreate Litchfield and Wilcoxon's Nomograph No. 1}
\usage{
LWnomo1(values = FALSE)
}
\arguments{
\item{values}{A logical scalar indicating whether values should be output.}
}
\value{
If \code{values} is TRUE, a list of length four, with the x and y
  coordinates and the corresponding values (all displayed in the log10
  scale) of the end points of the three scales.  Information is provided
  twice for the first scale, once for the left tick marks and once for the
  right tick marks.
}
\description{
Recreate Litchfield and Wilcoxon's (1949) nomograph to estimate the
contribution to the chi-squared from the expected percent effect and
the observed  minus the expected percent effect.
}
\details{
Use the nomograph by laying a straight edge from the expected percent effect
in the first scale to the observed (corrected, if necessary) minus the
expected percent effect in the second scale and reading the point where the
straight edge crosses the third scale as the contribution.

The formula behind the nomograph is
(observed - expected)^2 / (100 * expected)
}
\examples{
LWnomo1()
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}

