% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{CS}
\alias{CS}
\title{Compound Symmetry Structure}
\usage{
CS(formula, var.cluster, var.time, ...)
}
\arguments{
\item{formula}{formula indicating the cluster and a possible stratification.}

\item{var.cluster}{[character] used to check the cluster variable in the formula.}

\item{var.time}{[character] used to check the time variable in the formula.}

\item{...}{not used.}
}
\value{
An object of class \code{CS} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure where the residuals have constant variance and correlation.
Can be stratified on a categorical variable.
}
\details{
A typical formula would be \code{~1|id}, indicating a variance constant over time and the same correlation between all pairs of times.
}
\examples{
CS(~1|id)
CS(~1|id, var.time = "time", var.cluster = "id")
CS(group~1|id)
CS(group~time|id, var.time = "time", var.cluster = "id")

}
