% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxProCriterion.R
\name{MaxProCriterion}
\alias{MaxProCriterion}
\title{Calculate the Maximum Projection Criterion}
\usage{
MaxProCriterion(X)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating maximum projection criterion.
\code{maximum projection criterion = \\Bigg\{ \\frac{1}{{n \\choose 2}} \\sum_{i=1}^{n-1} \\sum_{j=i+1}^{n} \\frac{1}{\\Pi_{l=1}^{k}(x_{il}-x_{jl})^2}  \\Bigg\}^{1/k}}
}
\description{
\code{MaxProCriterion} returns the maximum projection criterion of an LHD
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the maximum projection criterion of toy
MaxProCriterion(X=toy)

}
\references{
Joseph, V. R., Gul, E., and Ba, S. (2015) Maximum projection designs for computer experiments. \emph{Biometrika}, \strong{102}, 371-380.
}
