% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AvgAbsCor.R
\name{AvgAbsCor}
\alias{AvgAbsCor}
\title{Calculate the Average Absolute Correlation}
\usage{
AvgAbsCor(X)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating the average absolute correlation of input matrix.
\code{average absolute correlation = \\frac{2 \\sum_{i=1}^{k-1} \\sum_{j=i+1}^{k}|q_{ij}|}{k(k-1)}}
}
\description{
\code{AvgAbsCor} returns the average absolute correlation of a matrix
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the average absolute correlation of toy
AvgAbsCor(X=toy)

}
\references{
Georgiou, S. D. (2009) Orthogonal Latin hypercube designs from generalized orthogonal designs. \emph{Journal of Statistical Planning and Inference}, \strong{139}, 1530-1540.
}
