% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{memoise_fun}
\alias{memoise_fun}
\title{Logical control on whether or not to memoise}
\usage{
memoise_fun(fun, memoise_tf = TRUE)
}
\arguments{
\item{fun}{Function name to (potentially) be memoised.}

\item{memoise_tf}{\code{logical} value indicating if \code{fun} should be 
memoised.}
}
\value{
\code{fun}, memoised if desired.
}
\description{
This function provides a simple, logical toggle control on
  whether the function \code{fun} should be memoised via
  \code{\link[memoise]{memoise}} or not.
}
\examples{
  sum_memo <- memoise_fun(sum)

}
