% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{logLik.TS_fit}
\alias{logLik.TS_fit}
\title{Determine the log likelihood of a Time Series model}
\usage{
\method{logLik}{TS_fit}(object, ...)
}
\arguments{
\item{object}{Class \code{TS_fit} object to be evaluated.}

\item{...}{Not used, simply included to maintain method compatibility.}
}
\value{
Log likelihood of the model \code{logLik}, also with \code{df}
  (degrees of freedom) and \code{nobs} (number of observations) values.
}
\description{
Convenience function to extract and format the log likelihood
  of a \code{TS_fit}-class object fit by \code{\link{multinom_TS}}.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  TSmod <- TS(data, gamma ~ 1, nchangepoints = 1, "newmoon", weights)
  logLik(TSmod)
}

}
