% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{weighted_score}
\alias{weighted_score}
\title{Weighted score calculation}
\usage{
weighted_score(x, pond = 1)
}
\arguments{
\item{x}{a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} object}

\item{pond}{the weights to use. Can be an integer, a vector of integers, the
name of one of the quality report variables or a list of weights for the
\code{\link{mQR_matrix}} objects.}
}
\value{
the input with an additionnal weighted score
}
\description{
Function to weight a pre-calculated score
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Compute the score
QR <- compute_score(QR, n_contrib_score = 2)

# Weighted score
QR <- weighted_score(QR, 2)
print(QR)

# Extract the weighted score
QR$modalities$score_pond

}
\seealso{
\link[=fr-weighted_score]{Traduction française}

Other QR_matrix functions: 
\code{\link{export_xlsx}()},
\code{\link{export_xlsx.QR_matrix}()},
\code{\link{export_xlsx.mQR_matrix}()},
\code{\link{extract_QR}()},
\code{\link{rbind.QR_matrix}()},
\code{\link{sort}()}
}
\concept{QR_matrix functions}
