% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitIncucyteDRCPlateData.R
\name{splitIncucyteDRCPlateData}
\alias{splitIncucyteDRCPlateData}
\title{splitIncucyteDRCPlateData}
\usage{
splitIncucyteDRCPlateData(platemap, platedata, group_columns, cut_time = NULL)
}
\arguments{
\item{platemap}{Platemap dataframe of the form generated by importPlatemapXML}

\item{platedata}{IncucyteDRCPlateData object to be split}

\item{group_columns}{Vector of columns that are present in the data frame to generate the groups.}

\item{cut_time}{The time at which to extract the data for the dose response curve.  Default is NULL.}
}
\value{
list of IncucyteDRCSet objects
}
\description{
Function to construct a list of IncucyteDRCSet objects from a IncucyteDRCPlateData object.
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)
}

