/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;

class DelegateObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateObjectMatrix2D(ObjectMatrix3D objectMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= objectMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(objectMatrix3D.rows(), objectMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= objectMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(objectMatrix3D.slices(), objectMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= objectMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(objectMatrix3D.slices(), objectMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = objectMatrix3D;
    }

    public synchronized Object getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public ObjectMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, Object object) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, object);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, object);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, object);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public ObjectMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperObjectMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public ObjectMatrix1D like1D(int n) {
        throw new InternalError();
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((ObjectMatrix1D)denseObjectMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseObjectMatrix1D;
    }
}

