/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntFactory1D;
import cern.colt.matrix.tint.IntFactory2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix1DProcedure;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class IntMatrix2DTest
extends TestCase {
    protected IntMatrix2D A;
    protected IntMatrix2D B;
    protected IntMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected Random rand = new Random(0L);

    public IntMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                this.A.setQuick(n2, n, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
        }
        for (n2 = 0; n2 < this.B.rows(); ++n2) {
            for (n = 0; n < this.B.columns(); ++n) {
                this.B.setQuick(n2, n, Math.max(1, this.rand.nextInt() % this.B.rows()));
            }
        }
        for (n2 = 0; n2 < this.Bt.rows(); ++n2) {
            for (n = 0; n < this.Bt.columns(); ++n) {
                this.Bt.setQuick(n2, n, Math.max(1, this.rand.nextInt() % this.Bt.rows()));
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateIntIntFunctionIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                int n3 = this.A.getQuick(n, i);
                n2 += n3 * n3;
            }
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square);
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntIntFunctionIntFunctionIntProcedure() {
        int n;
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return (double)Math.abs(n) > 0.2;
            }
        };
        int n2 = 0;
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                int n3 = this.A.getQuick(n, i);
                if (!((double)Math.abs(n3) > 0.2)) continue;
                n2 += n3 * n3;
            }
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square, intProcedure);
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntIntFunctionIntFunctionIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(n2);
                intArrayList2.add(n);
            }
        }
        n2 = 0;
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                int n3 = this.A.getQuick(n, i);
                n2 += n3 * n3;
            }
        }
        n = this.A.aggregate(IntFunctions.plus, IntFunctions.square, intArrayList, intArrayList2);
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testAggregateIntMatrix2DIntIntFunctionIntIntFunction() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                int n3 = this.A.getQuick(n, i);
                int n4 = this.B.getQuick(n, i);
                n2 += n3 * n4;
            }
        }
        n = this.A.aggregate(this.B, IntFunctions.plus, IntFunctions.mult);
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testAssignInt() {
        int n = this.rand.nextInt();
        this.A.assign(n);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3);
        for (int i = 0; i < intArrayList3.size(); ++i) {
            IntMatrix2DTest.assertEquals((int)n, (int)intArrayList3.getQuick(i));
        }
    }

    public void testAssignIntArrayArray() {
        int n;
        int n2;
        int[][] nArray = new int[this.A.rows()][this.A.columns()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                nArray[n2][n] = this.rand.nextInt();
            }
        }
        this.A.assign(nArray);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            IntMatrix2DTest.assertTrue((this.A.columns() == nArray[n2].length ? 1 : 0) != 0);
            for (n = 0; n < this.A.columns(); ++n) {
                IntMatrix2DTest.assertEquals((int)nArray[n2][n], (int)this.A.getQuick(n2, n));
            }
        }
    }

    public void testAssignIntFunction() {
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(IntFunctions.neg);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                int n = -intMatrix2D.getQuick(i, j);
                IntMatrix2DTest.assertEquals((int)n, (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignIntMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.B.getQuick(i, j), (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignIntMatrix2DIntIntFunction() {
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(this.B, IntFunctions.plus);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(i, j) + this.B.getQuick(i, j)), (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignIntMatrix2DIntIntFunctionIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(i);
                intArrayList2.add(n);
            }
        }
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(this.B, IntFunctions.plus, intArrayList, intArrayList2);
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                IntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(n, i) + this.B.getQuick(n, i)), (int)this.A.getQuick(n, i));
            }
        }
    }

    public void testAssignIntProcedureInt() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(intProcedure, -1);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(intMatrix2D.getQuick(i, j)) > 1) {
                    IntMatrix2DTest.assertEquals((int)-1, (int)this.A.getQuick(i, j));
                    continue;
                }
                IntMatrix2DTest.assertEquals((int)intMatrix2D.getQuick(i, j), (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignIntProcedureIntFunction() {
        IntProcedure intProcedure = new IntProcedure(){

            public boolean apply(int n) {
                return Math.abs(n) > 1;
            }
        };
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(intProcedure, IntFunctions.neg);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(intMatrix2D.getQuick(i, j)) > 1) {
                    IntMatrix2DTest.assertEquals((int)(-intMatrix2D.getQuick(i, j)), (int)this.A.getQuick(i, j));
                    continue;
                }
                IntMatrix2DTest.assertEquals((int)intMatrix2D.getQuick(i, j), (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (this.A.getQuick(i, j) == 0) continue;
                ++n2;
            }
        }
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsInt() {
        int n = 1;
        this.A.assign(n);
        boolean bl = this.A.equals(n);
        IntMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2);
        IntMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        IntMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        IntMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testForEachNonZero() {
        IntMatrix2D intMatrix2D = this.A.copy();
        IntIntIntFunction intIntIntFunction = new IntIntIntFunction(){

            public int apply(int n, int n2, int n3) {
                return -n3;
            }
        };
        this.A.forEachNonZero(intIntIntFunction);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)(-intMatrix2D.getQuick(i, j)), (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testMaxLocation() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1);
        int[] nArray = this.A.getMaxLocation();
        IntMatrix2DTest.assertEquals((int)7, (int)nArray[0]);
        IntMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)nArray[1]);
        IntMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)nArray[2]);
    }

    public void testMinLocation() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -1);
        int[] nArray = this.A.getMinLocation();
        IntMatrix2DTest.assertEquals((int)-7, (int)nArray[0]);
        IntMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)nArray[1]);
        IntMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)nArray[2]);
    }

    public void testGetNegativeValues() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3);
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(-7));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(-1));
    }

    public void testGetNonZeros() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3);
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(7));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(1));
    }

    public void testGetPositiveValues() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3);
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        IntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        IntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(7));
        IntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(1));
    }

    public void testToArray() {
        int[][] nArray = this.A.toArray();
        IntMatrix2DTest.assertTrue((this.A.rows() == nArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.A.rows(); ++i) {
            IntMatrix2DTest.assertTrue((this.A.columns() == nArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)0, (int)Math.abs(nArray[i][j] - this.A.getQuick(i, j)));
            }
        }
    }

    public void testVectorize() {
        IntMatrix1D intMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(j, i), (int)intMatrix1D.getQuick(n++));
            }
        }
    }

    public void testViewColumn() {
        IntMatrix1D intMatrix1D = this.A.viewColumn(this.A.columns() / 2);
        IntMatrix2DTest.assertEquals((long)this.A.rows(), (long)intMatrix1D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            IntMatrix2DTest.assertEquals((int)this.A.getQuick(i, this.A.columns() / 2), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewColumnFlip() {
        IntMatrix2D intMatrix2D = this.A.viewColumnFlip();
        IntMatrix2DTest.assertEquals((long)this.A.size(), (long)intMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(i, this.A.columns() - 1 - j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewDice() {
        IntMatrix2D intMatrix2D = this.A.viewDice();
        IntMatrix2DTest.assertEquals((int)this.A.rows(), (int)intMatrix2D.columns());
        IntMatrix2DTest.assertEquals((int)this.A.columns(), (int)intMatrix2D.rows());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(i, j), (int)intMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testViewPart() {
        IntMatrix2D intMatrix2D = this.A.viewPart(this.A.rows() / 2, this.A.columns() / 2, this.A.rows() / 3, this.A.columns() / 3);
        IntMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)intMatrix2D.rows());
        IntMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)intMatrix2D.columns());
        for (int i = 0; i < this.A.rows() / 3; ++i) {
            for (int j = 0; j < this.A.columns() / 3; ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(this.A.rows() / 2 + i, this.A.columns() / 2 + j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRow() {
        IntMatrix1D intMatrix1D = this.A.viewRow(this.A.rows() / 2);
        IntMatrix2DTest.assertEquals((long)this.A.columns(), (long)intMatrix1D.size());
        for (int i = 0; i < this.A.columns(); ++i) {
            IntMatrix2DTest.assertEquals((int)this.A.getQuick(this.A.rows() / 2, i), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewRowFlip() {
        IntMatrix2D intMatrix2D = this.A.viewRowFlip();
        IntMatrix2DTest.assertEquals((long)this.A.size(), (long)intMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(this.A.rows() - 1 - i, j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSelectionIntMatrix1DProcedure() {
        this.A.assign(0);
        this.A.setQuick(this.A.rows() / 4, 0, 2);
        this.A.setQuick(this.A.rows() / 2, 0, 2);
        IntMatrix2D intMatrix2D = this.A.viewSelection(new IntMatrix1DProcedure(){

            public boolean apply(IntMatrix1D intMatrix1D) {
                return Math.abs(intMatrix1D.getQuick(0) - 2) == 0;
            }
        });
        IntMatrix2DTest.assertEquals((int)2, (int)intMatrix2D.rows());
        IntMatrix2DTest.assertEquals((int)this.A.columns(), (int)intMatrix2D.columns());
        IntMatrix2DTest.assertEquals((int)this.A.getQuick(this.A.rows() / 4, 0), (int)intMatrix2D.getQuick(0, 0));
        IntMatrix2DTest.assertEquals((int)this.A.getQuick(this.A.rows() / 2, 0), (int)intMatrix2D.getQuick(1, 0));
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray2 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        IntMatrix2D intMatrix2D = this.A.viewSelection(nArray, nArray2);
        IntMatrix2DTest.assertEquals((int)nArray.length, (int)intMatrix2D.rows());
        IntMatrix2DTest.assertEquals((int)nArray2.length, (int)intMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(nArray[i], nArray2[j]), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSorted() {
        IntMatrix2D intMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.A.rows() - 1; ++i) {
            IntMatrix2DTest.assertTrue((intMatrix2D.getQuick(i + 1, 1) >= intMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        IntMatrix2D intMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < intMatrix2D.rows(); ++i) {
            for (int j = 0; j < intMatrix2D.columns(); ++j) {
                IntMatrix2DTest.assertEquals((int)this.A.getQuick(i * n, j * n2), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testZMultIntMatrix1DIntMatrix1DIntIntBoolean() {
        int n;
        int n2;
        int n3;
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(this.A.columns());
        int n4 = 0;
        while ((long)n4 < denseIntMatrix1D.size()) {
            ((IntMatrix1D)denseIntMatrix1D).setQuick(n4, this.rand.nextInt() % this.A.rows());
            ++n4;
        }
        n4 = 3;
        int n5 = 5;
        IntMatrix1D intMatrix1D = IntFactory1D.dense.random(this.A.rows());
        intMatrix1D.assign(IntFunctions.mod(this.A.rows()));
        int[] nArray = intMatrix1D.toArray();
        intMatrix1D = this.A.zMult(denseIntMatrix1D, intMatrix1D, n4, n5, false);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            n2 = 0;
            for (n = 0; n < this.A.columns(); ++n) {
                n2 += this.A.getQuick(n3, n) * ((IntMatrix1D)denseIntMatrix1D).getQuick(n);
            }
            nArray[n3] = n2 * n4 + nArray[n3] * n5;
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            IntMatrix2DTest.assertEquals((int)nArray[n3], (int)intMatrix1D.getQuick(n3));
        }
        intMatrix1D = null;
        intMatrix1D = this.A.zMult(denseIntMatrix1D, intMatrix1D, n4, n5, false);
        nArray = new int[this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            n2 = 0;
            for (n = 0; n < this.A.columns(); ++n) {
                n2 += this.A.getQuick(n3, n) * ((IntMatrix1D)denseIntMatrix1D).getQuick(n);
            }
            nArray[n3] = n2 * n4;
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            IntMatrix2DTest.assertEquals((int)nArray[n3], (int)intMatrix1D.getQuick(n3));
        }
        denseIntMatrix1D = new DenseIntMatrix1D(this.A.rows());
        n3 = 0;
        while ((long)n3 < denseIntMatrix1D.size()) {
            ((IntMatrix1D)denseIntMatrix1D).setQuick(n3, this.rand.nextInt() % this.A.rows());
            ++n3;
        }
        intMatrix1D = IntFactory1D.dense.random(this.A.columns());
        intMatrix1D.assign(IntFunctions.mod(this.A.rows()));
        nArray = intMatrix1D.toArray();
        intMatrix1D = this.A.zMult(denseIntMatrix1D, intMatrix1D, n4, n5, true);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            n2 = 0;
            for (n = 0; n < this.A.rows(); ++n) {
                n2 += this.A.getQuick(n, n3) * ((IntMatrix1D)denseIntMatrix1D).getQuick(n);
            }
            nArray[n3] = n2 * n4 + nArray[n3] * n5;
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            IntMatrix2DTest.assertEquals((int)nArray[n3], (int)intMatrix1D.getQuick(n3));
        }
        intMatrix1D = null;
        intMatrix1D = this.A.zMult(denseIntMatrix1D, intMatrix1D, n4, n5, true);
        nArray = new int[this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            n2 = 0;
            for (n = 0; n < this.A.rows(); ++n) {
                n2 += this.A.getQuick(n, n3) * ((IntMatrix1D)denseIntMatrix1D).getQuick(n);
            }
            nArray[n3] = n2 * n4;
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            IntMatrix2DTest.assertEquals((int)nArray[n3], (int)intMatrix1D.getQuick(n3));
        }
    }

    public void testZMultIntMatrix2DIntMatrix2DIntIntBooleanBoolean() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 3;
        int n6 = 5;
        IntMatrix2D intMatrix2D = IntFactory2D.dense.random(this.A.rows(), this.A.rows());
        intMatrix2D.assign(IntFunctions.mod(this.A.rows()));
        int[][] nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, false, false);
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.columns(); ++n) {
                    n2 += this.A.getQuick(n3, n) * this.Bt.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, false, false);
        nArray = new int[this.A.rows()][this.A.rows()];
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.columns(); ++n) {
                    n2 += this.A.getQuick(n3, n) * this.Bt.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = IntFactory2D.dense.random(this.A.columns(), this.A.columns());
        intMatrix2D.assign(IntFunctions.mod(this.A.rows()));
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, true, false);
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.rows(); ++n) {
                    n2 += this.A.getQuick(n, n3) * this.B.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, true, false);
        nArray = new int[this.A.columns()][this.A.columns()];
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.rows(); ++n) {
                    n2 += this.A.getQuick(n, n3) * this.B.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = IntFactory2D.dense.random(this.A.rows(), this.A.rows());
        intMatrix2D.assign(IntFunctions.mod(this.A.rows()));
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, false, true);
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.columns(); ++n) {
                    n2 += this.A.getQuick(n3, n) * this.B.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, false, true);
        nArray = new int[this.A.rows()][this.A.rows()];
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.columns(); ++n) {
                    n2 += this.A.getQuick(n3, n) * this.B.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.A.rows(); ++n4) {
            for (n3 = 0; n3 < this.A.rows(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = IntFactory2D.dense.random(this.A.columns(), this.A.columns());
        intMatrix2D.assign(IntFunctions.mod(this.A.rows()));
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, true, true);
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.rows(); ++n) {
                    n2 += this.A.getQuick(n, n3) * this.Bt.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, true, true);
        nArray = new int[this.A.columns()][this.A.columns()];
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                n2 = 0;
                for (n = 0; n < this.A.rows(); ++n) {
                    n2 += this.A.getQuick(n, n3) * this.Bt.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.A.columns(); ++n4) {
            for (n3 = 0; n3 < this.A.columns(); ++n3) {
                IntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
    }

    public void testZSum() {
        int n = this.A.zSum();
        int n2 = 0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                n2 += this.A.getQuick(i, j);
            }
        }
        IntMatrix2DTest.assertEquals((int)n2, (int)n);
    }
}

