/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;

    public SparseFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public SparseFComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new ConcurrentHashMap(n * (n2 / 1000));
    }

    protected SparseFComplexMatrix2D(int n, int n2, ConcurrentHashMap<Long, float[]> concurrentHashMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix2D assign(float[] fArray) {
        if (this.isNoView && fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (!(fComplexMatrix2D instanceof SparseFComplexMatrix2D)) {
            return super.assign(fComplexMatrix2D);
        }
        SparseFComplexMatrix2D sparseFComplexMatrix2D = (SparseFComplexMatrix2D)fComplexMatrix2D;
        if (sparseFComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseFComplexMatrix2D);
        if (this.isNoView && sparseFComplexMatrix2D.isNoView) {
            this.elements.clear();
            this.elements.putAll(sparseFComplexMatrix2D.elements);
            return this;
        }
        return super.assign(fComplexMatrix2D);
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        if (!this.isNoView) {
            return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
        }
        this.checkShape(fComplexMatrix2D);
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond) {
            final float[] fArray = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator;
            if (fArray[0] == 0.0f && fArray[1] == 1.0f) {
                return this;
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray2) {
                    SparseFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(SparseFComplexMatrix2D.this.getQuick(n, n2), FComplex.mult(fArray, fArray2)));
                    return fArray2;
                }
            });
            return this;
        }
        return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public float[] getQuick(int n, int n2) {
        float[] fArray = this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
        if (fArray != null) {
            return new float[]{fArray[0], fArray[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Long, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedSparseFComplexMatrix2D) {
            SelectedSparseFComplexMatrix2D selectedSparseFComplexMatrix2D = (SelectedSparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedSparseFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof SparseFComplexMatrix2D) {
            SparseFComplexMatrix2D sparseFComplexMatrix2D = (SparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == sparseFComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    @Override
    public FComplexMatrix2D like(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        return new SparseFComplexMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, float[] fArray) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public FComplexMatrix1D vectorize() {
        final SparseFComplexMatrix1D sparseFComplexMatrix1D = new SparseFComplexMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = 0;
                        for (int i = n3; i < n4; ++i) {
                            n = i * SparseFComplexMatrix2D.this.rows;
                            for (int j = 0; j < SparseFComplexMatrix2D.this.rows; ++j) {
                                float[] fArray = SparseFComplexMatrix2D.this.getQuick(j, i);
                                if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                                sparseFComplexMatrix1D.setQuick(n++, fArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray = this.getQuick(j, i);
                    if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                    sparseFComplexMatrix1D.setQuick(n5++, fArray);
                }
            }
        }
        return sparseFComplexMatrix1D;
    }

    @Override
    public void setQuick(int n, int n2, float f, float f2) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseFComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        final SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseFComplexMatrix2D.this.columns; ++j) {
                                sparseFloatMatrix2D.setQuick(i, j, SparseFComplexMatrix2D.this.getQuick(i, j)[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(i, j, this.getQuick(i, j)[1]);
                }
            }
        }
        return sparseFloatMatrix2D;
    }

    @Override
    public FloatMatrix2D getRealPart() {
        final SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseFComplexMatrix2D.this.columns; ++j) {
                                sparseFloatMatrix2D.setQuick(i, j, SparseFComplexMatrix2D.this.getQuick(i, j)[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(i, j, this.getQuick(i, j)[0]);
                }
            }
        }
        return sparseFloatMatrix2D;
    }
}

