/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseFComplexMatrix2D
extends FComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    protected float[] elements;

    public DenseFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length / 2);
        this.assign(fArray);
    }

    public DenseFComplexMatrix2D(FloatMatrix2D floatMatrix2D) {
        this(floatMatrix2D.rows(), floatMatrix2D.columns());
        this.assignReal(floatMatrix2D);
    }

    public DenseFComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 2 * n2, 2);
        this.elements = new float[n * 2 * n2];
    }

    public DenseFComplexMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.isNoView = bl;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size() == 0L) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0);
        float[] fArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n3 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        float[] fArray = fComplexFComplexFunction.apply(DenseFComplexMatrix2D.this.elements[n3], DenseFComplexMatrix2D.this.elements[n3 + 1]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                n3 = n + i * DenseFComplexMatrix2D.this.rowStride + j * DenseFComplexMatrix2D.this.columnStride;
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(DenseFComplexMatrix2D.this.elements[n3], DenseFComplexMatrix2D.this.elements[n3 + 1]));
                            }
                            n2 = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(this.elements[n], this.elements[n + 1]);
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    int n7 = n + i * this.rowStride + j * this.columnStride;
                    fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(this.elements[n7], this.elements[n7 + 1]));
                }
                n6 = 0;
            }
        }
        return fArray2;
    }

    @Override
    public float[] aggregate(FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        if (!(fComplexMatrix2D instanceof DenseFComplexMatrix2D)) {
            return super.aggregate(fComplexMatrix2D, fComplexFComplexFComplexFunction, fComplexFComplexFComplexFunction2);
        }
        this.checkShape(fComplexMatrix2D);
        float[] fArray = new float[2];
        if (this.size() == 0L) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)fComplexMatrix2D.index(0, 0);
        final int n3 = fComplexMatrix2D.rowStride();
        final int n4 = fComplexMatrix2D.columnStride();
        final float[] fArray2 = (float[])fComplexMatrix2D.elements();
        float[] fArray3 = null;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n5 = n + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n2 + n7 * n3;
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix2D.this.elements[n5], DenseFComplexMatrix2D.this.elements[n5 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                n5 = n + i * DenseFComplexMatrix2D.this.rowStride + j * DenseFComplexMatrix2D.this.columnStride;
                                n22 = n2 + i * n3 + j * n4;
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix2D.this.elements[n5], DenseFComplexMatrix2D.this.elements[n5 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]}));
                            }
                            n32 = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray3 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray3 = fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n], this.elements[n + 1]}, new float[]{fArray2[n2], fArray2[n2 + 1]});
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    int n10 = n + i * this.rowStride + j * this.columnStride;
                    int n11 = n2 + i * n3 + j * n4;
                    fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n10], this.elements[n10 + 1]}, new float[]{fArray2[n11], fArray2[n11 + 1]}));
                }
                n9 = 0;
            }
        }
        return fArray3;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            Object[] objectArray;
            if (fComplexFComplexFunction instanceof FComplexMult) {
                objectArray = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                if (objectArray[0] == 1.0f && objectArray[1] == 0.0f) {
                    return this;
                }
                if (objectArray[0] == 0.0f && objectArray[1] == 0.0f) {
                    return this.assign(0.0f, 0.0f);
                }
            }
            n2 = Math.min(n2, this.rows);
            objectArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                objectArray[i] = (float)ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        float[] fArray = new float[2];
                        if (fComplexFComplexFunction instanceof FComplexMult) {
                            float[] fArray2 = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray[0] = DenseFComplexMatrix2D.this.elements[n2];
                                    fArray[1] = DenseFComplexMatrix2D.this.elements[n2 + 1];
                                    DenseFComplexMatrix2D.this.elements[n2] = fArray[0] * fArray2[0] - fArray[1] * fArray2[1];
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = fArray[1] * fArray2[0] + fArray[0] * fArray2[1];
                                    n2 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseFComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray = fComplexFComplexFunction.apply(DenseFComplexMatrix2D.this.elements[n3], DenseFComplexMatrix2D.this.elements[n3 + 1]);
                                    DenseFComplexMatrix2D.this.elements[n3] = fArray[0];
                                    DenseFComplexMatrix2D.this.elements[n3 + 1] = fArray[1];
                                    n3 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseFComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            if (fComplexFComplexFunction instanceof FComplexMult) {
                float[] fArray2 = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                for (int i = 0; i < this.rows; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray[0] = this.elements[n7];
                        fArray[1] = this.elements[n7 + 1];
                        this.elements[n7] = fArray[0] * fArray2[0] - fArray[1] * fArray2[1];
                        this.elements[n7 + 1] = fArray[1] * fArray2[0] + fArray[0] * fArray2[1];
                        n7 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray = fComplexFComplexFunction.apply(this.elements[n8], this.elements[n8 + 1]);
                        this.elements[n8] = fArray[0];
                        this.elements[n8 + 1] = fArray[1];
                        n8 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        int n3 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[0] = DenseFComplexMatrix2D.this.elements[n2];
                                fArray[1] = DenseFComplexMatrix2D.this.elements[n2 + 1];
                                if (fComplexProcedure.apply(fArray)) {
                                    fArray = fComplexFComplexFunction.apply(fArray);
                                    DenseFComplexMatrix2D.this.elements[n2] = fArray[0];
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = fArray[1];
                                }
                                n2 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseFComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[0] = this.elements[n7];
                    fArray[1] = this.elements[n7 + 1];
                    if (fComplexProcedure.apply(fArray)) {
                        fArray = fComplexFComplexFunction.apply(fArray);
                        this.elements[n7] = fArray[0];
                        this.elements[n7 + 1] = fArray[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        float[] fArray2 = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray2[0] = DenseFComplexMatrix2D.this.elements[n2];
                                fArray2[1] = DenseFComplexMatrix2D.this.elements[n2 + 1];
                                if (fComplexProcedure.apply(fArray2)) {
                                    DenseFComplexMatrix2D.this.elements[n2] = fArray[0];
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = fArray[1];
                                }
                                n2 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseFComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray2[0] = this.elements[n7];
                    fArray2[1] = this.elements[n7 + 1];
                    if (fComplexProcedure.apply(fArray2)) {
                        this.elements[n7] = fArray[0];
                        this.elements[n7 + 1] = fArray[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexRealFunction fComplexRealFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        float[] fArray = new float[2];
                        if (fComplexRealFunction == FComplexFunctions.abs) {
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    float f;
                                    fArray[0] = DenseFComplexMatrix2D.this.elements[n2];
                                    fArray[1] = DenseFComplexMatrix2D.this.elements[n2 + 1];
                                    float f2 = Math.abs(DenseFComplexMatrix2D.this.elements[n2]);
                                    float f3 = Math.abs(DenseFComplexMatrix2D.this.elements[n2 + 1]);
                                    if (f2 == 0.0f && f3 == 0.0f) {
                                        DenseFComplexMatrix2D.this.elements[n2] = 0.0f;
                                    } else if (f2 >= f3) {
                                        f = fArray[1] / fArray[0];
                                        DenseFComplexMatrix2D.this.elements[n2] = f2 * (float)Math.sqrt(1.0f + f * f);
                                    } else {
                                        f = fArray[0] / fArray[1];
                                        DenseFComplexMatrix2D.this.elements[n2] = f3 * (float)Math.sqrt(1.0f + f * f);
                                    }
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = 0.0f;
                                    n2 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseFComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray[0] = DenseFComplexMatrix2D.this.elements[n3];
                                    fArray[1] = DenseFComplexMatrix2D.this.elements[n3 + 1];
                                    fArray[0] = fComplexRealFunction.apply(fArray);
                                    DenseFComplexMatrix2D.this.elements[n3] = fArray[0];
                                    DenseFComplexMatrix2D.this.elements[n3 + 1] = 0.0f;
                                    n3 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseFComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            if (fComplexRealFunction == FComplexFunctions.abs) {
                for (int i = 0; i < this.rows; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        float f;
                        fArray[0] = this.elements[n7];
                        fArray[1] = this.elements[n7 + 1];
                        float f2 = Math.abs(fArray[0]);
                        float f3 = Math.abs(fArray[1]);
                        if (f2 == 0.0f && f3 == 0.0f) {
                            this.elements[n7] = 0.0f;
                        } else if (f2 >= f3) {
                            f = fArray[1] / fArray[0];
                            this.elements[n7] = f2 * (float)Math.sqrt(1.0f + f * f);
                        } else {
                            f = fArray[0] / fArray[1];
                            this.elements[n7] = f3 * (float)Math.sqrt(1.0f + f * f);
                        }
                        this.elements[n7 + 1] = 0.0f;
                        n7 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray[0] = this.elements[n8];
                        fArray[1] = this.elements[n8 + 1];
                        fArray[0] = fComplexRealFunction.apply(fArray);
                        this.elements[n8] = fArray[0];
                        this.elements[n8 + 1] = 0.0f;
                        n8 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        Object object;
        if (!(fComplexMatrix2D instanceof DenseFComplexMatrix2D)) {
            super.assign(fComplexMatrix2D);
            return this;
        }
        DenseFComplexMatrix2D denseFComplexMatrix2D = (DenseFComplexMatrix2D)fComplexMatrix2D;
        if (denseFComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(denseFComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseFComplexMatrix2D.isNoView) {
            System.arraycopy(denseFComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseFComplexMatrix2D)) {
            object = denseFComplexMatrix2D.copy();
            if (!(object instanceof DenseFComplexMatrix2D)) {
                super.assign(denseFComplexMatrix2D);
                return this;
            }
            denseFComplexMatrix2D = (DenseFComplexMatrix2D)object;
        }
        object = denseFComplexMatrix2D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        int n2 = denseFComplexMatrix2D.columnStride;
        final int n3 = denseFComplexMatrix2D.rowStride;
        final int n4 = (int)denseFComplexMatrix2D.index(0, 0);
        final int n5 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((float[])object, n2){
                    final /* synthetic */ float[] val$elemsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elemsOther = fArray;
                        this.val$columnStrideOther = n6;
                    }

                    public void run() {
                        int n = n5 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n2 = n4 + n7 * n3;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n;
                            int n42 = n2;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                DenseFComplexMatrix2D.this.elements[n32] = this.val$elemsOther[n42];
                                DenseFComplexMatrix2D.this.elements[n32 + 1] = this.val$elemsOther[n42 + 1];
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += this.val$columnStrideOther;
                            }
                            n += DenseFComplexMatrix2D.this.rowStride;
                            n2 += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n5;
            int n10 = n4;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = (float)object[n12];
                    this.elements[n11 + 1] = (float)object[n12 + 1];
                    n11 += this.columnStride;
                    n12 += n2;
                }
                n9 += this.rowStride;
                n10 += n3;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        if (!(fComplexMatrix2D instanceof DenseFComplexMatrix2D)) {
            super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        final float[] fArray = ((DenseFComplexMatrix2D)fComplexMatrix2D).elements;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        final int n = fComplexMatrix2D.columnStride();
        final int n2 = fComplexMatrix2D.rowStride();
        final int n3 = (int)fComplexMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n11 = n4 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        float[] fArray3 = new float[2];
                        float[] fArray2 = new float[2];
                        if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n11;
                                int n42 = n22;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray3[0] = DenseFComplexMatrix2D.this.elements[n32];
                                    fArray3[1] = DenseFComplexMatrix2D.this.elements[n32 + 1];
                                    fArray2[0] = fArray[n42];
                                    fArray2[1] = fArray[n42 + 1];
                                    DenseFComplexMatrix2D.this.elements[n32] = fArray3[0] * fArray2[0] - fArray3[1] * fArray2[1];
                                    DenseFComplexMatrix2D.this.elements[n32 + 1] = fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                    n32 += DenseFComplexMatrix2D.this.columnStride;
                                    n42 += n;
                                }
                                n11 += DenseFComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                            for (int i = n7; i < n8; ++i) {
                                int n5 = n11;
                                int n6 = n22;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray3[0] = DenseFComplexMatrix2D.this.elements[n5];
                                    fArray3[1] = DenseFComplexMatrix2D.this.elements[n5 + 1];
                                    fArray2[0] = fArray[n6];
                                    fArray2[1] = fArray[n6 + 1];
                                    DenseFComplexMatrix2D.this.elements[n5] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                    DenseFComplexMatrix2D.this.elements[n5 + 1] = -fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                    n5 += DenseFComplexMatrix2D.this.columnStride;
                                    n6 += n;
                                }
                                n11 += DenseFComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n11;
                                int n82 = n22;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray3[0] = DenseFComplexMatrix2D.this.elements[n72];
                                    fArray3[1] = DenseFComplexMatrix2D.this.elements[n72 + 1];
                                    fArray2[0] = fArray[n82];
                                    fArray2[1] = fArray[n82 + 1];
                                    DenseFComplexMatrix2D.this.elements[n72] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                    DenseFComplexMatrix2D.this.elements[n72 + 1] = fArray3[1] * fArray2[0] - fArray3[0] * fArray2[1];
                                    n72 += DenseFComplexMatrix2D.this.columnStride;
                                    n82 += n;
                                }
                                n11 += DenseFComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else {
                            for (int i = n7; i < n8; ++i) {
                                int n9 = n11;
                                int n10 = n22;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    fArray3[0] = DenseFComplexMatrix2D.this.elements[n9];
                                    fArray3[1] = DenseFComplexMatrix2D.this.elements[n9 + 1];
                                    fArray2[0] = fArray[n10];
                                    fArray2[1] = fArray[n10 + 1];
                                    fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fArray2);
                                    DenseFComplexMatrix2D.this.elements[n9] = fArray3[0];
                                    DenseFComplexMatrix2D.this.elements[n9 + 1] = fArray3[1];
                                    n9 += DenseFComplexMatrix2D.this.columnStride;
                                    n10 += n;
                                }
                                n11 += DenseFComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            int n9 = n4;
            int n10 = n3;
            if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                for (int i = 0; i < this.rows; ++i) {
                    int n11 = n9;
                    int n12 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray2[0] = this.elements[n11];
                        fArray2[1] = this.elements[n11 + 1];
                        fArray3[0] = fArray[n12];
                        fArray3[1] = fArray[n12 + 1];
                        this.elements[n11] = fArray2[0] * fArray3[0] - fArray2[1] * fArray3[1];
                        this.elements[n11 + 1] = fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                        n11 += this.columnStride;
                        n12 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.rows; ++i) {
                    int n13 = n9;
                    int n14 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray2[0] = this.elements[n13];
                        fArray2[1] = this.elements[n13 + 1];
                        fArray3[0] = fArray[n14];
                        fArray3[1] = fArray[n14 + 1];
                        this.elements[n13] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                        this.elements[n13 + 1] = -fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                        n13 += this.columnStride;
                        n14 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.rows; ++i) {
                    int n15 = n9;
                    int n16 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray2[0] = this.elements[n15];
                        fArray2[1] = this.elements[n15 + 1];
                        fArray3[0] = fArray[n16];
                        fArray3[1] = fArray[n16 + 1];
                        this.elements[n15] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                        this.elements[n15 + 1] = fArray2[1] * fArray3[0] - fArray2[0] * fArray3[1];
                        n15 += this.columnStride;
                        n16 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n17 = n9;
                    int n18 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        fArray2[0] = this.elements[n17];
                        fArray2[1] = this.elements[n17 + 1];
                        fArray3[0] = fArray[n18];
                        fArray3[1] = fArray[n18 + 1];
                        fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fArray3);
                        this.elements[n17] = fArray2[0];
                        this.elements[n17 + 1] = fArray2[1];
                        n17 += this.columnStride;
                        n18 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float f, final float f2) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                DenseFComplexMatrix2D.this.elements[n2] = f;
                                DenseFComplexMatrix2D.this.elements[n2 + 1] = f2;
                                n2 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseFComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n7] = f;
                    this.elements[n7 + 1] = f2;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.rows : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseFComplexMatrix2D.this.columns * 2;
                            int n22 = n2 + n4 * DenseFComplexMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    DenseFComplexMatrix2D.this.elements[n3] = fArray[n++];
                                    DenseFComplexMatrix2D.this.elements[n3 + 1] = fArray[n++];
                                    n3 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n22 += DenseFComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n8] = fArray[n6++];
                        this.elements[n8 + 1] = fArray[n6++];
                        n8 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[][] fArray) {
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = 2 * DenseFComplexMatrix2D.this.columns;
                            int n2 = n3 * DenseFComplexMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != n) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + n);
                                }
                                System.arraycopy(fArray2, 0, DenseFComplexMatrix2D.this.elements, n2, n);
                                n2 += n;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 2 * this.columns;
                int n6 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2.length != n5) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + n5);
                    }
                    System.arraycopy(fArray2, 0, this.elements, n6, n5);
                    n6 += n5;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n8 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n - 1 ? this.rows : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n9 * DenseFComplexMatrix2D.this.rowStride;
                            for (int i = n9; i < n10; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != 2 * DenseFComplexMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + 2 * DenseFComplexMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                    DenseFComplexMatrix2D.this.elements[n2] = fArray2[2 * j];
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = fArray2[2 * j + 1];
                                    n2 += DenseFComplexMatrix2D.this.columnStride;
                                }
                                n += DenseFComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n11 = n7;
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray3 = fArray[i];
                    if (fArray3.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "2*columns()=" + 2 * this.columns());
                    }
                    int n12 = n11;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n12] = fArray3[2 * j];
                        this.elements[n12 + 1] = fArray3[2 * j + 1];
                        n12 += this.columnStride;
                    }
                    n11 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignImaginary(FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        final int n = floatMatrix2D.columnStride();
        final int n2 = floatMatrix2D.rowStride();
        final int n3 = (int)floatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                DenseFComplexMatrix2D.this.elements[n32 + 1] = fArray[n42];
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseFComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11 + 1] = fArray[n12];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignReal(FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        final int n = floatMatrix2D.columnStride();
        final int n2 = floatMatrix2D.rowStride();
        final int n3 = (int)floatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                DenseFComplexMatrix2D.this.elements[n32] = fArray[n42];
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseFComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = fArray[n12];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseFComplexMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                if ((double)DenseFComplexMatrix2D.this.elements[n32] != 0.0 || (double)DenseFComplexMatrix2D.this.elements[n32 + 1] != 0.0) {
                                    ++n;
                                }
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n2 += DenseFComplexMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if ((double)this.elements[n9] != 0.0 || (double)this.elements[n9 + 1] != 0.0) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexForward(this.elements);
        } else {
            FComplexMatrix2D fComplexMatrix2D = this.copy();
            this.fft2.complexForward((float[])fComplexMatrix2D.elements());
            this.assign((float[])fComplexMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewColumn(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFComplexMatrix1D)this.viewColumn(i)).fft();
            }
        }
    }

    public void fftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewRow(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFComplexMatrix1D)this.viewRow(i)).fft();
            }
        }
    }

    @Override
    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction intIntFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFComplexMatrix2D.this.rowStride;
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[0] = DenseFComplexMatrix2D.this.elements[n2];
                                fArray[1] = DenseFComplexMatrix2D.this.elements[n2 + 1];
                                if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                                    float[] fArray2 = intIntFComplexFunction.apply(i, j, fArray);
                                    DenseFComplexMatrix2D.this.elements[n2] = fArray2[0];
                                    DenseFComplexMatrix2D.this.elements[n2 + 1] = fArray2[1];
                                }
                                n2 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseFComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[0] = this.elements[n7];
                    fArray[1] = this.elements[n7 + 1];
                    if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                        float[] fArray2 = intIntFComplexFunction.apply(i, j, fArray);
                        this.elements[n7] = fArray2[0];
                        this.elements[n7 + 1] = fArray2[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D getConjugateTranspose() {
        FComplexMatrix2D fComplexMatrix2D = this.viewDice().copy();
        final float[] fArray = ((DenseFComplexMatrix2D)fComplexMatrix2D).elements;
        final int n = (int)fComplexMatrix2D.index(0, 0);
        final int n2 = fComplexMatrix2D.columnStride();
        final int n3 = fComplexMatrix2D.rowStride();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        final int n5 = fComplexMatrix2D.columns();
        int n6 = fComplexMatrix2D.rows();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, n6);
            Future[] futureArray = new Future[n4];
            int n7 = n6 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n4 - 1 ? n6 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + n8 * n3;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                fArray[n4 + 1] = -fArray[n4 + 1];
                                n4 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    fArray[n10 + 1] = -fArray[n10 + 1];
                    n10 += n2;
                }
            }
        }
        return fComplexMatrix2D;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        final float[] fArray = denseFloatMatrix2D.elements();
        final int n = denseFloatMatrix2D.columnStride();
        final int n2 = denseFloatMatrix2D.rowStride();
        final int n3 = (int)denseFloatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[n42] = DenseFComplexMatrix2D.this.elements[n32 + 1];
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseFComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[n12] = this.elements[n11 + 1];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return denseFloatMatrix2D;
    }

    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                float[] fArray = new float[]{this.elements[n2], this.elements[n2 + 1]};
                if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    arrayList.add(fArray);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    @Override
    public float[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        return new float[]{this.elements[n3], this.elements[n3 + 1]};
    }

    @Override
    public FloatMatrix2D getRealPart() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        final float[] fArray = denseFloatMatrix2D.elements();
        final int n = denseFloatMatrix2D.columnStride();
        final int n2 = denseFloatMatrix2D.rowStride();
        final int n3 = (int)denseFloatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[n42] = DenseFComplexMatrix2D.this.elements[n32];
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseFComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[n12] = this.elements[n11];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return denseFloatMatrix2D;
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexInverse(this.elements, bl);
        } else {
            FComplexMatrix2D fComplexMatrix2D = this.copy();
            this.fft2.complexInverse((float[])fComplexMatrix2D.elements(), bl);
            this.assign((float[])fComplexMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewColumn(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFComplexMatrix1D)this.viewColumn(i)).ifft(bl);
            }
        }
    }

    public void ifftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewRow(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFComplexMatrix1D)this.viewRow(i)).ifft(bl);
            }
        }
    }

    @Override
    public FComplexMatrix2D like(int n, int n2) {
        return new DenseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix1D like1D(int n) {
        return new DenseFComplexMatrix1D(n);
    }

    @Override
    public void setQuick(int n, int n2, float f, float f2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = f;
        this.elements[n3 + 1] = f2;
    }

    @Override
    public void setQuick(int n, int n2, float[] fArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = fArray[0];
        this.elements[n3 + 1] = fArray[1];
    }

    @Override
    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseFComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n22 = n;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[i][2 * j] = DenseFComplexMatrix2D.this.elements[n22];
                                fArray[i][2 * j + 1] = DenseFComplexMatrix2D.this.elements[n22 + 1];
                                n22 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n += DenseFComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[i][2 * j] = this.elements[n7];
                    fArray[i][2 * j + 1] = this.elements[n7 + 1];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return fArray;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D((int)this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)((AbstractMatrix1D)denseFComplexMatrix1D).index(0);
        final int n3 = denseFComplexMatrix1D.stride();
        final float[] fArray = (float[])((FComplexMatrix1D)denseFComplexMatrix1D).elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                final int n8 = i * n5 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n8 * n3;
                        for (int i = n6; i < n7; ++i) {
                            n4 = n + i * DenseFComplexMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.rows; ++j) {
                                fArray[n22] = DenseFComplexMatrix2D.this.elements[n4];
                                fArray[n22 + 1] = DenseFComplexMatrix2D.this.elements[n4 + 1];
                                n4 += DenseFComplexMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = 0;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[n10] = this.elements[n9];
                    fArray[n10 + 1] = this.elements[n9 + 1];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseFComplexMatrix1D;
    }

    @Override
    public FComplexMatrix1D zMult(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2, final float[] fArray, final float[] fArray2, boolean bl) {
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray, fArray2, false);
        }
        FComplexMatrix1D fComplexMatrix1D3 = fComplexMatrix1D2 == null ? new DenseFComplexMatrix1D(this.rows) : fComplexMatrix1D2;
        if ((long)this.columns != fComplexMatrix1D.size() || (long)this.rows > fComplexMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + fComplexMatrix1D.toStringShort() + ", " + fComplexMatrix1D3.toStringShort());
        }
        final float[] fArray3 = (float[])fComplexMatrix1D.elements();
        final float[] fArray4 = (float[])fComplexMatrix1D3.elements();
        if (this.elements == null || fArray3 == null || fArray4 == null) {
            throw new InternalError();
        }
        final int n = fComplexMatrix1D.stride();
        final int n2 = fComplexMatrix1D3.stride();
        final int n3 = (int)this.index(0, 0);
        final int n4 = (int)fComplexMatrix1D.index(0);
        final int n5 = (int)fComplexMatrix1D3.index(0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.rows);
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n3 + n8 * DenseFComplexMatrix2D.this.rowStride;
                        int n22 = n5 + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            float f = 0.0f;
                            float f2 = 0.0f;
                            int n32 = n6;
                            int n42 = n4;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                float f3 = DenseFComplexMatrix2D.this.elements[n32];
                                float f4 = DenseFComplexMatrix2D.this.elements[n32 + 1];
                                float f5 = fArray3[n42];
                                float f6 = fArray3[n42 + 1];
                                f += f3 * f5 - f4 * f6;
                                f2 += f4 * f5 + f3 * f6;
                                n32 += DenseFComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            float f7 = fArray4[n22];
                            float f8 = fArray4[n22 + 1];
                            fArray4[n22] = f * fArray[0] - f2 * fArray[1] + f7 * fArray2[0] - f8 * fArray2[1];
                            fArray4[n22 + 1] = f2 * fArray[0] + f * fArray[1] + f8 * fArray2[0] + f7 * fArray2[1];
                            n6 += DenseFComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            int n11 = n5;
            for (int i = 0; i < this.rows; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                int n12 = n10;
                int n13 = n4;
                for (int j = 0; j < this.columns; ++j) {
                    float f3 = this.elements[n12];
                    float f4 = this.elements[n12 + 1];
                    float f5 = fArray3[n13];
                    float f6 = fArray3[n13 + 1];
                    f += f3 * f5 - f4 * f6;
                    f2 += f4 * f5 + f3 * f6;
                    n12 += this.columnStride;
                    n13 += n;
                }
                float f7 = fArray4[n11];
                float f8 = fArray4[n11 + 1];
                fArray4[n11] = f * fArray[0] - f2 * fArray[1] + f7 * fArray2[0] - f8 * fArray2[1];
                fArray4[n11 + 1] = f2 * fArray[0] + f * fArray[1] + f8 * fArray2[0] + f7 * fArray2[1];
                n10 += this.rowStride;
                n11 += n2;
            }
        }
        return fComplexMatrix1D3;
    }

    @Override
    public FComplexMatrix2D zMult(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, final float[] fArray, final float[] fArray2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = fComplexMatrix2D.rows();
        int n5 = fComplexMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = new DenseFComplexMatrix2D(n6, n);
        }
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(fComplexMatrix2D.getConjugateTranspose(), fComplexMatrix2D2, fArray, fArray2, bl, false);
        }
        if (fComplexMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n2 || fComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n2 * (long)n3 * (long)n5;
        int n8 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n5 >= n8;
        int n9 = bl3 ? n5 : n2;
        n8 = Math.min(n9, n8);
        if (n8 < 2) {
            return this.zMultSeq(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, bl, bl2);
        }
        int n10 = n9 / n8;
        Future[] futureArray = new Future[n8];
        for (int i = 0; i < n8; ++i) {
            FComplexMatrix2D fComplexMatrix2D3;
            FComplexMatrix2D fComplexMatrix2D4;
            FComplexMatrix2D fComplexMatrix2D5;
            int n11 = i * n10;
            if (i == n8 - 1) {
                n10 = n9 - n10 * i;
            }
            if (bl3) {
                fComplexMatrix2D5 = this;
                fComplexMatrix2D4 = fComplexMatrix2D.viewPart(0, n11, n3, n10);
                fComplexMatrix2D3 = fComplexMatrix2D2.viewPart(0, n11, n2, n10);
            } else {
                fComplexMatrix2D5 = this.viewPart(n11, 0, n10, n3);
                fComplexMatrix2D4 = fComplexMatrix2D;
                fComplexMatrix2D3 = fComplexMatrix2D2.viewPart(n11, 0, n10, n5);
            }
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseFComplexMatrix2D)fComplexMatrix2D5).zMultSeq(fComplexMatrix2D4, fComplexMatrix2D3, fArray, fArray2, bl, bl2);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
        return fComplexMatrix2D2;
    }

    protected FComplexMatrix2D zMultSeq(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(fComplexMatrix2D.getConjugateTranspose(), fComplexMatrix2D2, fArray, fArray2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = fComplexMatrix2D.columns();
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = new DenseFComplexMatrix2D(n, n3);
        }
        if (!(fComplexMatrix2D2 instanceof DenseFComplexMatrix2D)) {
            return super.zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, bl, bl2);
        }
        if (fComplexMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n || fComplexMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseFComplexMatrix2D denseFComplexMatrix2D = (DenseFComplexMatrix2D)fComplexMatrix2D;
        DenseFComplexMatrix2D denseFComplexMatrix2D2 = (DenseFComplexMatrix2D)fComplexMatrix2D2;
        float[] fArray3 = this.elements;
        float[] fArray4 = denseFComplexMatrix2D.elements;
        float[] fArray5 = denseFComplexMatrix2D2.elements;
        if (fArray3 == null || fArray4 == null || fArray5 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseFComplexMatrix2D.columnStride;
        int n6 = denseFComplexMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseFComplexMatrix2D.rowStride;
        int n9 = denseFComplexMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseFComplexMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseFComplexMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    int n20 = n17;
                    int n21 = n13;
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                    }
                    float f7 = fArray5[n18];
                    float f8 = fArray5[n18 + 1];
                    fArray5[n18] = fArray[0] * f5 - fArray[1] * f6 + fArray2[0] * f7 - fArray2[1] * f8;
                    fArray5[n18 + 1] = fArray[1] * f5 + fArray[0] * f6 + fArray2[1] * f7 + fArray2[0] * f8;
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return fComplexMatrix2D2;
    }

    @Override
    public float[] zSum() {
        float[] fArray = new float[2];
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.rows : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        int n4 = n + n3 * DenseFComplexMatrix2D.this.rowStride;
                        for (int i = n3; i < n5; ++i) {
                            int n2 = n4;
                            for (int j = 0; j < DenseFComplexMatrix2D.this.columns; ++j) {
                                fArray[0] = fArray[0] + DenseFComplexMatrix2D.this.elements[n2];
                                fArray[1] = fArray[1] + DenseFComplexMatrix2D.this.elements[n2 + 1];
                                n2 += DenseFComplexMatrix2D.this.columnStride;
                            }
                            n4 += DenseFComplexMatrix2D.this.rowStride;
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    float[] fArray2 = (float[])futureArray[n3].get();
                    fArray[0] = fArray[0] + fArray2[0];
                    fArray[1] = fArray[1] + fArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[0] = fArray[0] + this.elements[n7];
                    fArray[1] = fArray[1] + this.elements[n7 + 1];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return fArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedDenseFComplexMatrix2D) {
            SelectedDenseFComplexMatrix2D selectedDenseFComplexMatrix2D = (SelectedDenseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedDenseFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof DenseFComplexMatrix2D) {
            DenseFComplexMatrix2D denseFComplexMatrix2D = (DenseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == denseFComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        return new DenseFComplexMatrix1D(n, this.elements, n2, n3, false);
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseFComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

