/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseColumnFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseColumnFComplexMatrix2D
extends FComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    protected float[] elements;

    public DenseColumnFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length / 2);
        this.assign(fArray);
    }

    public DenseColumnFComplexMatrix2D(FloatMatrix2D floatMatrix2D) {
        this(floatMatrix2D.rows(), floatMatrix2D.columns());
        this.assignReal(floatMatrix2D);
    }

    public DenseColumnFComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 2, 2 * n);
        this.elements = new float[n * 2 * n2];
    }

    public DenseColumnFComplexMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.isNoView = bl;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size() == 0L) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0);
        float[] fArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n3 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] fArray = fComplexFComplexFunction.apply(DenseColumnFComplexMatrix2D.this.elements[n3], DenseColumnFComplexMatrix2D.this.elements[n3 + 1]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                n3 = n + j * DenseColumnFComplexMatrix2D.this.rowStride + i * DenseColumnFComplexMatrix2D.this.columnStride;
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(DenseColumnFComplexMatrix2D.this.elements[n3], DenseColumnFComplexMatrix2D.this.elements[n3 + 1]));
                            }
                            n2 = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(this.elements[n], this.elements[n + 1]);
            int n6 = 1;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = n6; j < this.rows; ++j) {
                    int n7 = n + j * this.rowStride + i * this.columnStride;
                    fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(this.elements[n7], this.elements[n7 + 1]));
                }
                n6 = 0;
            }
        }
        return fArray2;
    }

    @Override
    public float[] aggregate(FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        if (!(fComplexMatrix2D instanceof DenseColumnFComplexMatrix2D)) {
            return super.aggregate(fComplexMatrix2D, fComplexFComplexFComplexFunction, fComplexFComplexFComplexFunction2);
        }
        this.checkShape(fComplexMatrix2D);
        float[] fArray = new float[2];
        if (this.size() == 0L) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)fComplexMatrix2D.index(0, 0);
        final int n3 = fComplexMatrix2D.rowStride();
        final int n4 = fComplexMatrix2D.columnStride();
        final float[] fArray2 = (float[])fComplexMatrix2D.elements();
        float[] fArray3 = null;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n5 = n + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n2 + n7 * n4;
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(new float[]{DenseColumnFComplexMatrix2D.this.elements[n5], DenseColumnFComplexMatrix2D.this.elements[n5 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                n5 = n + j * DenseColumnFComplexMatrix2D.this.rowStride + i * DenseColumnFComplexMatrix2D.this.columnStride;
                                n22 = n2 + j * n3 + i * n4;
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(new float[]{DenseColumnFComplexMatrix2D.this.elements[n5], DenseColumnFComplexMatrix2D.this.elements[n5 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]}));
                            }
                            n32 = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray3 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray3 = fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n], this.elements[n + 1]}, new float[]{fArray2[n2], fArray2[n2 + 1]});
            int n9 = 1;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = n9; j < this.rows; ++j) {
                    int n10 = n + j * this.rowStride + i * this.columnStride;
                    int n11 = n2 + j * n3 + i * n4;
                    fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n10], this.elements[n10 + 1]}, new float[]{fArray2[n11], fArray2[n11 + 1]}));
                }
                n9 = 0;
            }
        }
        return fArray3;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            Object[] objectArray;
            if (fComplexFComplexFunction instanceof FComplexMult) {
                objectArray = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                if (objectArray[0] == 1.0f && objectArray[1] == 0.0f) {
                    return this;
                }
                if (objectArray[0] == 0.0f && objectArray[1] == 0.0f) {
                    return this.assign(0.0f, 0.0f);
                }
            }
            n2 = Math.min(n2, this.columns);
            objectArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                objectArray[i] = (float)ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] fArray = new float[2];
                        if (fComplexFComplexFunction instanceof FComplexMult) {
                            float[] fArray2 = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray[0] = DenseColumnFComplexMatrix2D.this.elements[n2];
                                    fArray[1] = DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[n2] = fArray[0] * fArray2[0] - fArray[1] * fArray2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = fArray[1] * fArray2[0] + fArray[0] * fArray2[1];
                                    n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray = fComplexFComplexFunction.apply(DenseColumnFComplexMatrix2D.this.elements[n3], DenseColumnFComplexMatrix2D.this.elements[n3 + 1]);
                                    DenseColumnFComplexMatrix2D.this.elements[n3] = fArray[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n3 + 1] = fArray[1];
                                    n3 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            if (fComplexFComplexFunction instanceof FComplexMult) {
                float[] fArray2 = ((FComplexMult)fComplexFComplexFunction).multiplicator;
                for (int i = 0; i < this.columns; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray[0] = this.elements[n7];
                        fArray[1] = this.elements[n7 + 1];
                        this.elements[n7] = fArray[0] * fArray2[0] - fArray[1] * fArray2[1];
                        this.elements[n7 + 1] = fArray[1] * fArray2[0] + fArray[0] * fArray2[1];
                        n7 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray = fComplexFComplexFunction.apply(this.elements[n8], this.elements[n8 + 1]);
                        this.elements[n8] = fArray[0];
                        this.elements[n8 + 1] = fArray[1];
                        n8 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        int n3 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[0] = DenseColumnFComplexMatrix2D.this.elements[n2];
                                fArray[1] = DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                if (fComplexProcedure.apply(fArray)) {
                                    fArray = fComplexFComplexFunction.apply(fArray);
                                    DenseColumnFComplexMatrix2D.this.elements[n2] = fArray[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = fArray[1];
                                }
                                n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[0] = this.elements[n7];
                    fArray[1] = this.elements[n7 + 1];
                    if (fComplexProcedure.apply(fArray)) {
                        fArray = fComplexFComplexFunction.apply(fArray);
                        this.elements[n7] = fArray[0];
                        this.elements[n7 + 1] = fArray[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] fArray2 = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray2[0] = DenseColumnFComplexMatrix2D.this.elements[n2];
                                fArray2[1] = DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                if (fComplexProcedure.apply(fArray2)) {
                                    DenseColumnFComplexMatrix2D.this.elements[n2] = fArray[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = fArray[1];
                                }
                                n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    fArray2[0] = this.elements[n7];
                    fArray2[1] = this.elements[n7 + 1];
                    if (fComplexProcedure.apply(fArray2)) {
                        this.elements[n7] = fArray[0];
                        this.elements[n7 + 1] = fArray[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexRealFunction fComplexRealFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] fArray = new float[2];
                        if (fComplexRealFunction == FComplexFunctions.abs) {
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    float f;
                                    fArray[0] = DenseColumnFComplexMatrix2D.this.elements[n2];
                                    fArray[1] = DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                    float f2 = Math.abs(DenseColumnFComplexMatrix2D.this.elements[n2]);
                                    float f3 = Math.abs(DenseColumnFComplexMatrix2D.this.elements[n2 + 1]);
                                    if (f2 == 0.0f && f3 == 0.0f) {
                                        DenseColumnFComplexMatrix2D.this.elements[n2] = 0.0f;
                                    } else if (f2 >= f3) {
                                        f = fArray[1] / fArray[0];
                                        DenseColumnFComplexMatrix2D.this.elements[n2] = (float)((double)f2 * Math.sqrt(1.0f + f * f));
                                    } else {
                                        f = fArray[0] / fArray[1];
                                        DenseColumnFComplexMatrix2D.this.elements[n2] = (float)((double)f3 * Math.sqrt(1.0f + f * f));
                                    }
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = 0.0f;
                                    n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray[0] = DenseColumnFComplexMatrix2D.this.elements[n3];
                                    fArray[1] = DenseColumnFComplexMatrix2D.this.elements[n3 + 1];
                                    fArray[0] = fComplexRealFunction.apply(fArray);
                                    DenseColumnFComplexMatrix2D.this.elements[n3] = fArray[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n3 + 1] = 0.0f;
                                    n3 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            if (fComplexRealFunction == FComplexFunctions.abs) {
                for (int i = 0; i < this.columns; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        float f;
                        fArray[0] = this.elements[n7];
                        fArray[1] = this.elements[n7 + 1];
                        float f2 = Math.abs(fArray[0]);
                        float f3 = Math.abs(fArray[1]);
                        if (f2 == 0.0f && f3 == 0.0f) {
                            this.elements[n7] = 0.0f;
                        } else if (f2 >= f3) {
                            f = fArray[1] / fArray[0];
                            this.elements[n7] = (float)((double)f2 * Math.sqrt(1.0f + f * f));
                        } else {
                            f = fArray[0] / fArray[1];
                            this.elements[n7] = (float)((double)f3 * Math.sqrt(1.0f + f * f));
                        }
                        this.elements[n7 + 1] = 0.0f;
                        n7 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray[0] = this.elements[n8];
                        fArray[1] = this.elements[n8 + 1];
                        fArray[0] = fComplexRealFunction.apply(fArray);
                        this.elements[n8] = fArray[0];
                        this.elements[n8 + 1] = 0.0f;
                        n8 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        Object object;
        if (!(fComplexMatrix2D instanceof DenseColumnFComplexMatrix2D)) {
            super.assign(fComplexMatrix2D);
            return this;
        }
        DenseColumnFComplexMatrix2D denseColumnFComplexMatrix2D = (DenseColumnFComplexMatrix2D)fComplexMatrix2D;
        if (denseColumnFComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnFComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnFComplexMatrix2D.isNoView) {
            System.arraycopy(denseColumnFComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnFComplexMatrix2D)) {
            object = denseColumnFComplexMatrix2D.copy();
            if (!(object instanceof DenseColumnFComplexMatrix2D)) {
                super.assign(denseColumnFComplexMatrix2D);
                return this;
            }
            denseColumnFComplexMatrix2D = (DenseColumnFComplexMatrix2D)object;
        }
        object = denseColumnFComplexMatrix2D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n2 = denseColumnFComplexMatrix2D.columnStride;
        int n3 = denseColumnFComplexMatrix2D.rowStride;
        final int n4 = (int)denseColumnFComplexMatrix2D.index(0, 0);
        final int n5 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((float[])object, n3){
                    final /* synthetic */ float[] val$elemsOther;
                    final /* synthetic */ int val$rowStrideOther;
                    {
                        this.val$elemsOther = fArray;
                        this.val$rowStrideOther = n6;
                    }

                    public void run() {
                        int n = n5 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n4 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n3 = n;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                DenseColumnFComplexMatrix2D.this.elements[n3] = this.val$elemsOther[n42];
                                DenseColumnFComplexMatrix2D.this.elements[n3 + 1] = this.val$elemsOther[n42 + 1];
                                n3 += DenseColumnFComplexMatrix2D.this.rowStride;
                                n42 += this.val$rowStrideOther;
                            }
                            n += DenseColumnFComplexMatrix2D.this.columnStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n5;
            int n10 = n4;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11] = (float)object[n12];
                    this.elements[n11 + 1] = (float)object[n12 + 1];
                    n11 += this.rowStride;
                    n12 += n3;
                }
                n9 += this.columnStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        if (!(fComplexMatrix2D instanceof DenseColumnFComplexMatrix2D)) {
            super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        final float[] fArray = ((DenseColumnFComplexMatrix2D)fComplexMatrix2D).elements;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        final int n = fComplexMatrix2D.columnStride();
        final int n2 = fComplexMatrix2D.rowStride();
        final int n3 = (int)fComplexMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n11 = n4 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        float[] fArray3 = new float[2];
                        float[] fArray2 = new float[2];
                        if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n11;
                                int n42 = n22;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray3[0] = DenseColumnFComplexMatrix2D.this.elements[n32];
                                    fArray3[1] = DenseColumnFComplexMatrix2D.this.elements[n32 + 1];
                                    fArray2[0] = fArray[n42];
                                    fArray2[1] = fArray[n42 + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[n32] = fArray3[0] * fArray2[0] - fArray3[1] * fArray2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[n32 + 1] = fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                    n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                                    n42 += n2;
                                }
                                n11 += DenseColumnFComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                            for (int i = n7; i < n8; ++i) {
                                int n5 = n11;
                                int n6 = n22;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray3[0] = DenseColumnFComplexMatrix2D.this.elements[n5];
                                    fArray3[1] = DenseColumnFComplexMatrix2D.this.elements[n5 + 1];
                                    fArray2[0] = fArray[n6];
                                    fArray2[1] = fArray[n6 + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[n5] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[n5 + 1] = -fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                    n5 += DenseColumnFComplexMatrix2D.this.rowStride;
                                    n6 += n2;
                                }
                                n11 += DenseColumnFComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n11;
                                int n82 = n22;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray3[0] = DenseColumnFComplexMatrix2D.this.elements[n72];
                                    fArray3[1] = DenseColumnFComplexMatrix2D.this.elements[n72 + 1];
                                    fArray2[0] = fArray[n82];
                                    fArray2[1] = fArray[n82 + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[n72] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[n72 + 1] = fArray3[1] * fArray2[0] - fArray3[0] * fArray2[1];
                                    n72 += DenseColumnFComplexMatrix2D.this.rowStride;
                                    n82 += n2;
                                }
                                n11 += DenseColumnFComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else {
                            for (int i = n7; i < n8; ++i) {
                                int n9 = n11;
                                int n10 = n22;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray3[0] = DenseColumnFComplexMatrix2D.this.elements[n9];
                                    fArray3[1] = DenseColumnFComplexMatrix2D.this.elements[n9 + 1];
                                    fArray2[0] = fArray[n10];
                                    fArray2[1] = fArray[n10 + 1];
                                    fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fArray2);
                                    DenseColumnFComplexMatrix2D.this.elements[n9] = fArray3[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n9 + 1] = fArray3[1];
                                    n9 += DenseColumnFComplexMatrix2D.this.rowStride;
                                    n10 += n2;
                                }
                                n11 += DenseColumnFComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            int n9 = n4;
            int n10 = n3;
            if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                for (int i = 0; i < this.columns; ++i) {
                    int n11 = n9;
                    int n12 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray2[0] = this.elements[n11];
                        fArray2[1] = this.elements[n11 + 1];
                        fArray3[0] = fArray[n12];
                        fArray3[1] = fArray[n12 + 1];
                        this.elements[n11] = fArray2[0] * fArray3[0] - fArray2[1] * fArray3[1];
                        this.elements[n11 + 1] = fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                        n11 += this.rowStride;
                        n12 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.columns; ++i) {
                    int n13 = n9;
                    int n14 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray2[0] = this.elements[n13];
                        fArray2[1] = this.elements[n13 + 1];
                        fArray3[0] = fArray[n14];
                        fArray3[1] = fArray[n14 + 1];
                        this.elements[n13] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                        this.elements[n13 + 1] = -fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                        n13 += this.rowStride;
                        n14 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.columns; ++i) {
                    int n15 = n9;
                    int n16 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray2[0] = this.elements[n15];
                        fArray2[1] = this.elements[n15 + 1];
                        fArray3[0] = fArray[n16];
                        fArray3[1] = fArray[n16 + 1];
                        this.elements[n15] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                        this.elements[n15 + 1] = fArray2[1] * fArray3[0] - fArray2[0] * fArray3[1];
                        n15 += this.rowStride;
                        n16 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n17 = n9;
                    int n18 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray2[0] = this.elements[n17];
                        fArray2[1] = this.elements[n17 + 1];
                        fArray3[0] = fArray[n18];
                        fArray3[1] = fArray[n18 + 1];
                        fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fArray3);
                        this.elements[n17] = fArray2[0];
                        this.elements[n17 + 1] = fArray2[1];
                        n17 += this.rowStride;
                        n18 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float f, final float f2) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                DenseColumnFComplexMatrix2D.this.elements[n2] = f;
                                DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = f2;
                                n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n7] = f;
                    this.elements[n7 + 1] = f2;
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.columns : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseColumnFComplexMatrix2D.this.rows * 2;
                            int n22 = n2 + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    DenseColumnFComplexMatrix2D.this.elements[n3] = fArray[n++];
                                    DenseColumnFComplexMatrix2D.this.elements[n3 + 1] = fArray[n++];
                                    n3 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n22 += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.rows; ++j) {
                        this.elements[n8] = fArray[n6++];
                        this.elements[n8 + 1] = fArray[n6++];
                        n8 += this.rowStride;
                    }
                    n7 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[][] fArray) {
        if (fArray.length != this.columns) {
            throw new IllegalArgumentException("Must have same number of columns: values.length=" + fArray.length + "columns()=" + this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n2 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.columns : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = 2 * DenseColumnFComplexMatrix2D.this.rows;
                            int n2 = n3 * DenseColumnFComplexMatrix2D.this.columnStride;
                            for (int i = n3; i < n4; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != n) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + fArray2.length + "2*rows()=" + n);
                                }
                                System.arraycopy(fArray2, 0, DenseColumnFComplexMatrix2D.this.elements, n2, n);
                                n2 += n;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 2 * this.rows;
                int n6 = 0;
                for (int i = 0; i < this.columns; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2.length != n5) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + fArray2.length + "2*rows()=" + n5);
                    }
                    System.arraycopy(fArray2, 0, this.elements, n6, n5);
                    n6 += n5;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n8 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n - 1 ? this.columns : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n9 * DenseColumnFComplexMatrix2D.this.columnStride;
                            for (int i = n9; i < n10; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != 2 * DenseColumnFComplexMatrix2D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + fArray2.length + "2*rows()=" + n);
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    DenseColumnFComplexMatrix2D.this.elements[n2] = fArray2[2 * j];
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = fArray2[2 * j + 1];
                                    n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                                }
                                n += DenseColumnFComplexMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n11 = n7;
                for (int i = 0; i < this.columns; ++i) {
                    float[] fArray3 = fArray[i];
                    if (fArray3.length != 2 * this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + fArray3.length + "2*rows()=" + n11);
                    }
                    int n12 = n11;
                    for (int j = 0; j < this.rows; ++j) {
                        this.elements[n12] = fArray3[2 * j];
                        this.elements[n12 + 1] = fArray3[2 * j + 1];
                        n12 += this.rowStride;
                    }
                    n11 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignImaginary(FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        final int n = floatMatrix2D.columnStride();
        final int n2 = floatMatrix2D.rowStride();
        final int n3 = (int)floatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                DenseColumnFComplexMatrix2D.this.elements[n32 + 1] = fArray[n42];
                                n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnFComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11 + 1] = fArray[n12];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignReal(FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        final int n = floatMatrix2D.columnStride();
        final int n2 = floatMatrix2D.rowStride();
        final int n3 = (int)floatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                DenseColumnFComplexMatrix2D.this.elements[n32] = fArray[n42];
                                n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnFComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11] = fArray[n12];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.columns : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseColumnFComplexMatrix2D.this.columnStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                if ((double)DenseColumnFComplexMatrix2D.this.elements[n32] != 0.0 || (double)DenseColumnFComplexMatrix2D.this.elements[n32 + 1] != 0.0) {
                                    ++n;
                                }
                                n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n2 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.rows; ++j) {
                    if ((double)this.elements[n9] != 0.0 || (double)this.elements[n9 + 1] != 0.0) {
                        ++n;
                    }
                    n9 += this.rowStride;
                }
                n8 += this.columnStride;
            }
        }
        return n;
    }

    public void fft2() {
        FComplexMatrix2D fComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward((float[])fComplexMatrix2D.elements());
        this.assign(fComplexMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewColumn(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFComplexMatrix1D)this.viewColumn(i)).fft();
            }
        }
    }

    public void fftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewRow(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFComplexMatrix1D)this.viewRow(i)).fft();
            }
        }
    }

    @Override
    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction intIntFComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[0] = DenseColumnFComplexMatrix2D.this.elements[n2];
                                fArray[1] = DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                                    float[] fArray2 = intIntFComplexFunction.apply(j, i, fArray);
                                    DenseColumnFComplexMatrix2D.this.elements[n2] = fArray2[0];
                                    DenseColumnFComplexMatrix2D.this.elements[n2 + 1] = fArray2[1];
                                }
                                n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            float[] fArray = new float[2];
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[0] = this.elements[n7];
                    fArray[1] = this.elements[n7 + 1];
                    if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                        float[] fArray2 = intIntFComplexFunction.apply(j, i, fArray);
                        this.elements[n7] = fArray2[0];
                        this.elements[n7 + 1] = fArray2[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D getConjugateTranspose() {
        FComplexMatrix2D fComplexMatrix2D = this.viewDice().copy();
        final float[] fArray = ((DenseColumnFComplexMatrix2D)fComplexMatrix2D).elements;
        final int n = (int)fComplexMatrix2D.index(0, 0);
        final int n2 = fComplexMatrix2D.columnStride();
        int n3 = fComplexMatrix2D.rowStride();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        int n5 = fComplexMatrix2D.columns();
        final int n6 = fComplexMatrix2D.rows();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, n5);
            Future[] futureArray = new Future[n4];
            int n7 = n5 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n4 - 1 ? n5 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < n6; ++j) {
                                fArray[n3 + 1] = -fArray[n3 + 1];
                                n3 += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    fArray[n10 + 1] = -fArray[n10 + 1];
                    n10 += 2;
                }
            }
        }
        return fComplexMatrix2D;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final float[] fArray = denseColumnFloatMatrix2D.elements();
        final int n = denseColumnFloatMatrix2D.columnStride();
        final int n2 = denseColumnFloatMatrix2D.rowStride();
        final int n3 = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[n42] = DenseColumnFComplexMatrix2D.this.elements[n32 + 1];
                                n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnFComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[n12] = this.elements[n11 + 1];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return denseColumnFloatMatrix2D;
    }

    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                float[] fArray = new float[]{this.elements[n2], this.elements[n2 + 1]};
                if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    arrayList.add(fArray);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    @Override
    public float[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        return new float[]{this.elements[n3], this.elements[n3 + 1]};
    }

    @Override
    public FloatMatrix2D getRealPart() {
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final float[] fArray = denseColumnFloatMatrix2D.elements();
        final int n = denseColumnFloatMatrix2D.columnStride();
        final int n2 = denseColumnFloatMatrix2D.rowStride();
        final int n3 = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnFComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[n42] = DenseColumnFComplexMatrix2D.this.elements[n32];
                                n32 += DenseColumnFComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnFComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[n12] = this.elements[n11];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return denseColumnFloatMatrix2D;
    }

    public void ifft2(boolean bl) {
        FComplexMatrix2D fComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse((float[])fComplexMatrix2D.elements(), bl);
        this.assign(fComplexMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewColumn(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFComplexMatrix1D)this.viewColumn(i)).ifft(bl);
            }
        }
    }

    public void ifftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewRow(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFComplexMatrix1D)this.viewRow(i)).ifft(bl);
            }
        }
    }

    @Override
    public FComplexMatrix2D like(int n, int n2) {
        return new DenseColumnFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix1D like1D(int n) {
        return new DenseFComplexMatrix1D(n);
    }

    @Override
    public void setQuick(int n, int n2, float f, float f2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = f;
        this.elements[n3 + 1] = f2;
    }

    @Override
    public void setQuick(int n, int n2, float[] fArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = fArray[0];
        this.elements[n3 + 1] = fArray[1];
    }

    @Override
    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseColumnFComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n22 = n;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[j][2 * i] = DenseColumnFComplexMatrix2D.this.elements[n22];
                                fArray[j][2 * i + 1] = DenseColumnFComplexMatrix2D.this.elements[n22 + 1];
                                n22 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[j][2 * i] = this.elements[n7];
                    fArray[j][2 * i + 1] = this.elements[n7 + 1];
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return fArray;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D((int)this.size());
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((FComplexMatrix1D)denseFComplexMatrix1D).elements(), 0, this.elements.length);
        } else {
            final int n = (int)this.index(0, 0);
            final int n2 = (int)((AbstractMatrix1D)denseFComplexMatrix1D).index(0);
            final int n3 = denseFComplexMatrix1D.stride();
            final float[] fArray = (float[])((FComplexMatrix1D)denseFComplexMatrix1D).elements();
            int n4 = ConcurrencyUtils.getNumberOfThreads();
            if (n4 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n4 = Math.min(n4, this.columns);
                Future[] futureArray = new Future[n4];
                int n5 = this.columns / n4;
                for (int i = 0; i < n4; ++i) {
                    final int n6 = i * n5;
                    final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                    final int n8 = i * n5 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n4 = 0;
                            int n22 = n2 + n8 * n3;
                            for (int i = n6; i < n7; ++i) {
                                n4 = n + i * DenseColumnFComplexMatrix2D.this.columnStride;
                                for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                    fArray[n22] = DenseColumnFComplexMatrix2D.this.elements[n4];
                                    fArray[n22 + 1] = DenseColumnFComplexMatrix2D.this.elements[n4 + 1];
                                    n4 += DenseColumnFComplexMatrix2D.this.rowStride;
                                    n22 += n3;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n9 = 0;
                int n10 = n2;
                for (int i = 0; i < this.columns; ++i) {
                    n9 = n + i * this.columnStride;
                    for (int j = 0; j < this.rows; ++j) {
                        fArray[n10] = this.elements[n9];
                        fArray[n10 + 1] = this.elements[n9 + 1];
                        n9 += this.rowStride;
                        n10 += n3;
                    }
                }
            }
        }
        return denseFComplexMatrix1D;
    }

    @Override
    public FComplexMatrix2D zMult(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, final float[] fArray, final float[] fArray2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = fComplexMatrix2D.rows();
        int n5 = fComplexMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = new DenseColumnFComplexMatrix2D(n6, n);
        }
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(fComplexMatrix2D.getConjugateTranspose(), fComplexMatrix2D2, fArray, fArray2, bl, false);
        }
        if (fComplexMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n2 || fComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n2 * (long)n3 * (long)n5;
        int n8 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n5 >= n8;
        int n9 = bl3 ? n5 : n2;
        n8 = Math.min(n9, n8);
        if (n8 < 2) {
            return this.zMultSeq(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, bl, bl2);
        }
        int n10 = n9 / n8;
        Future[] futureArray = new Future[n8];
        for (int i = 0; i < n8; ++i) {
            FComplexMatrix2D fComplexMatrix2D3;
            FComplexMatrix2D fComplexMatrix2D4;
            FComplexMatrix2D fComplexMatrix2D5;
            int n11 = i * n10;
            if (i == n8 - 1) {
                n10 = n9 - n10 * i;
            }
            if (bl3) {
                fComplexMatrix2D5 = this;
                fComplexMatrix2D4 = fComplexMatrix2D.viewPart(0, n11, n3, n10);
                fComplexMatrix2D3 = fComplexMatrix2D2.viewPart(0, n11, n2, n10);
            } else {
                fComplexMatrix2D5 = this.viewPart(n11, 0, n10, n3);
                fComplexMatrix2D4 = fComplexMatrix2D;
                fComplexMatrix2D3 = fComplexMatrix2D2.viewPart(n11, 0, n10, n5);
            }
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseColumnFComplexMatrix2D)fComplexMatrix2D5).zMultSeq(fComplexMatrix2D4, fComplexMatrix2D3, fArray, fArray2, bl, bl2);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
        return fComplexMatrix2D2;
    }

    protected FComplexMatrix2D zMultSeq(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(fComplexMatrix2D.getConjugateTranspose(), fComplexMatrix2D2, fArray, fArray2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = fComplexMatrix2D.columns();
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = new DenseColumnFComplexMatrix2D(n, n3);
        }
        if (!(fComplexMatrix2D2 instanceof DenseColumnFComplexMatrix2D)) {
            return super.zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, bl, bl2);
        }
        if (fComplexMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n || fComplexMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseColumnFComplexMatrix2D denseColumnFComplexMatrix2D = (DenseColumnFComplexMatrix2D)fComplexMatrix2D;
        DenseColumnFComplexMatrix2D denseColumnFComplexMatrix2D2 = (DenseColumnFComplexMatrix2D)fComplexMatrix2D2;
        float[] fArray3 = this.elements;
        float[] fArray4 = denseColumnFComplexMatrix2D.elements;
        float[] fArray5 = denseColumnFComplexMatrix2D2.elements;
        if (fArray3 == null || fArray4 == null || fArray5 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseColumnFComplexMatrix2D.columnStride;
        int n6 = denseColumnFComplexMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseColumnFComplexMatrix2D.rowStride;
        int n9 = denseColumnFComplexMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseColumnFComplexMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseColumnFComplexMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    int n20 = n17;
                    int n21 = n13;
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                        f4 = fArray3[n20 += n4];
                        f3 = fArray3[n20 + 1];
                        f2 = fArray4[n21 += n8];
                        f = fArray4[n21 + 1];
                        f5 += f4 * f2 - f3 * f;
                        f6 += f3 * f2 + f4 * f;
                    }
                    float f7 = fArray5[n18];
                    float f8 = fArray5[n18 + 1];
                    fArray5[n18] = fArray[0] * f5 - fArray[1] * f6 + fArray2[0] * f7 - fArray2[1] * f8;
                    fArray5[n18 + 1] = fArray[1] * f5 + fArray[0] * f6 + fArray2[1] * f7 + fArray2[0] * f8;
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return fComplexMatrix2D2;
    }

    @Override
    public float[] zSum() {
        float[] fArray = new float[2];
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n4 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.columns : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        int n4 = n + n3 * DenseColumnFComplexMatrix2D.this.columnStride;
                        for (int i = n3; i < n5; ++i) {
                            int n2 = n4;
                            for (int j = 0; j < DenseColumnFComplexMatrix2D.this.rows; ++j) {
                                fArray[0] = fArray[0] + DenseColumnFComplexMatrix2D.this.elements[n2];
                                fArray[1] = fArray[1] + DenseColumnFComplexMatrix2D.this.elements[n2 + 1];
                                n2 += DenseColumnFComplexMatrix2D.this.rowStride;
                            }
                            n4 += DenseColumnFComplexMatrix2D.this.columnStride;
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    float[] fArray2 = (float[])futureArray[n3].get();
                    fArray[0] = fArray[0] + fArray2[0];
                    fArray[1] = fArray[1] + fArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[0] = fArray[0] + this.elements[n7];
                    fArray[1] = fArray[1] + this.elements[n7 + 1];
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return fArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedDenseColumnFComplexMatrix2D) {
            SelectedDenseColumnFComplexMatrix2D selectedDenseColumnFComplexMatrix2D = (SelectedDenseColumnFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedDenseColumnFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof DenseColumnFComplexMatrix2D) {
            DenseColumnFComplexMatrix2D denseColumnFComplexMatrix2D = (DenseColumnFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == denseColumnFComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        return new DenseFComplexMatrix1D(n, this.elements, n2, n3, false);
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnFComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

