/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    private DoubleFFT_1D fft;
    private DoubleDCT_1D dct;
    private DoubleDST_1D dst;
    private DoubleDHT_1D dht;
    protected double[] elements;

    public DenseDoubleMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public DenseDoubleMatrix1D(int n) {
        this.setUp(n);
        this.elements = new double[n];
    }

    public DenseDoubleMatrix1D(int n, double[] dArray, int n2, int n3, boolean bl) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.isNoView = !bl;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.size - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int n = DenseDoubleMatrix1D.this.zero + (n3 - 1) * DenseDoubleMatrix1D.this.stride;
                        double d = doubleFunction.apply(DenseDoubleMatrix1D.this.elements[n]);
                        int n2 = n3 - 1;
                        while (--n2 >= n4) {
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(DenseDoubleMatrix1D.this.elements[n -= DenseDoubleMatrix1D.this.stride]));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            int n5 = this.zero + (this.size - 1) * this.stride;
            d = doubleFunction.apply(this.elements[n5]);
            int n6 = this.size - 1;
            while (--n6 >= 0) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements[n5 -= this.stride]));
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int n = DenseDoubleMatrix1D.this.zero + nArray[n4] * DenseDoubleMatrix1D.this.stride;
                        double d = doubleFunction.apply(DenseDoubleMatrix1D.this.elements[n]);
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = DenseDoubleMatrix1D.this.zero + nArray[i] * DenseDoubleMatrix1D.this.stride;
                            double d2 = DenseDoubleMatrix1D.this.elements[n];
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            int n6 = this.zero + nArray[0] * this.stride;
            d = doubleFunction.apply(this.elements[n6]);
            for (int i = 1; i < n; ++i) {
                n6 = this.zero + nArray[i] * this.stride;
                double d2 = this.elements[n6];
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public double aggregate(DoubleMatrix1D doubleMatrix1D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.aggregate(doubleMatrix1D, doubleDoubleFunction, doubleDoubleFunction2);
        }
        this.checkSize(doubleMatrix1D);
        if (this.size == 0) {
            return Double.NaN;
        }
        final int n = (int)doubleMatrix1D.index(0);
        final int n2 = doubleMatrix1D.stride();
        final double[] dArray = (double[])doubleMatrix1D.elements();
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int n3 = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        double d = doubleDoubleFunction2.apply(DenseDoubleMatrix1D.this.elements[n3], dArray[n22]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DenseDoubleMatrix1D.this.elements[n3 += DenseDoubleMatrix1D.this.stride], dArray[n22 += n2]));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleDoubleFunction2.apply(this.elements[this.zero], dArray[n]);
            int n7 = this.zero;
            int n8 = n;
            for (int i = 1; i < this.size; ++i) {
                d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.elements[n7 += this.stride], dArray[n8 += n2]));
            }
        }
        return d;
    }

    public DoubleMatrix1D assign(final DoubleFunction doubleFunction) {
        int n;
        double d;
        if (doubleFunction instanceof DoubleMult) {
            d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
        } else {
            d = 0.0;
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDoubleMatrix1D.this.zero + n3 * DenseDoubleMatrix1D.this.stride;
                        if (doubleFunction instanceof DoubleMult) {
                            for (int i = n3; i < n4; ++i) {
                                int n2 = n;
                                DenseDoubleMatrix1D.this.elements[n2] = DenseDoubleMatrix1D.this.elements[n2] * d;
                                n += DenseDoubleMatrix1D.this.stride;
                            }
                        } else {
                            for (int i = n3; i < n4; ++i) {
                                DenseDoubleMatrix1D.this.elements[n] = doubleFunction.apply(DenseDoubleMatrix1D.this.elements[n]);
                                n += DenseDoubleMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero - this.stride;
            if (doubleFunction instanceof DoubleMult) {
                int n6 = this.size;
                while (--n6 >= 0) {
                    this.elements[n5 += this.stride] = this.elements[n5] * d;
                }
            } else {
                int n7 = this.size;
                while (--n7 >= 0) {
                    this.elements[n5 += this.stride] = doubleFunction.apply(this.elements[n5]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDoubleMatrix1D.this.zero + n3 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (doubleProcedure.apply(DenseDoubleMatrix1D.this.elements[n])) {
                                DenseDoubleMatrix1D.this.elements[n] = doubleFunction.apply(DenseDoubleMatrix1D.this.elements[n]);
                            }
                            n += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (doubleProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = doubleFunction.apply(this.elements[n5]);
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure doubleProcedure, final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDoubleMatrix1D.this.zero + n3 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (doubleProcedure.apply(DenseDoubleMatrix1D.this.elements[n])) {
                                DenseDoubleMatrix1D.this.elements[n] = d;
                            }
                            n += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (doubleProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = d;
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double d) {
        final double[] dArray = this.elements;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDoubleMatrix1D.this.zero + n3 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            dArray[n] = d;
                            n += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray[n5] = d;
                n5 += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double[] dArray) {
        if (dArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + dArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDoubleMatrix1D.this.zero + n3 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseDoubleMatrix1D.this.elements[n] = dArray[i];
                            n += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = dArray[i];
                n5 += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D) {
        Object object;
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            super.assign(doubleMatrix1D);
            return this;
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        if (denseDoubleMatrix1D == this) {
            return this;
        }
        this.checkSize(denseDoubleMatrix1D);
        if (this.isNoView && denseDoubleMatrix1D.isNoView) {
            System.arraycopy(denseDoubleMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseDoubleMatrix1D)) {
            object = denseDoubleMatrix1D.copy();
            if (!(object instanceof DenseDoubleMatrix1D)) {
                super.assign(doubleMatrix1D);
                return this;
            }
            denseDoubleMatrix1D = (DenseDoubleMatrix1D)object;
        }
        object = denseDoubleMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = (int)denseDoubleMatrix1D.index(0);
        final int n2 = denseDoubleMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((double[])object){
                    final /* synthetic */ double[] val$elementsOther;
                    {
                        this.val$elementsOther = dArray;
                    }

                    public void run() {
                        int n3 = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseDoubleMatrix1D.this.elements[n3] = this.val$elementsOther[n22];
                            n3 += DenseDoubleMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (double)object[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D, final DoubleDoubleFunction doubleDoubleFunction) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            super.assign(doubleMatrix1D, doubleDoubleFunction);
            return this;
        }
        this.checkSize(doubleMatrix1D);
        final int n = (int)doubleMatrix1D.index(0);
        final int n2 = doubleMatrix1D.stride();
        final double[] dArray = (double[])doubleMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        if (doubleDoubleFunction == DoubleFunctions.mult) {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = n9;
                                DenseDoubleMatrix1D.this.elements[n3] = DenseDoubleMatrix1D.this.elements[n3] * dArray[n22];
                                n9 += DenseDoubleMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (doubleDoubleFunction == DoubleFunctions.div) {
                            for (int i = n5; i < n6; ++i) {
                                int n4 = n9;
                                DenseDoubleMatrix1D.this.elements[n4] = DenseDoubleMatrix1D.this.elements[n4] / dArray[n22];
                                n9 += DenseDoubleMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
                            double d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
                            if (d == 0.0) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseDoubleMatrix1D.this.elements[n9] = dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (d == 1.0) {
                                for (int i = n5; i < n6; ++i) {
                                    int n52 = n9;
                                    DenseDoubleMatrix1D.this.elements[n52] = DenseDoubleMatrix1D.this.elements[n52] + dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (d == -1.0) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseDoubleMatrix1D.this.elements[n9] = dArray[n22] - DenseDoubleMatrix1D.this.elements[n9];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    DenseDoubleMatrix1D.this.elements[n9] = d * DenseDoubleMatrix1D.this.elements[n9] + dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                            double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                            if (d == 0.0) {
                                return;
                            }
                            if (d == 1.0) {
                                for (int i = n5; i < n6; ++i) {
                                    int n62 = n9;
                                    DenseDoubleMatrix1D.this.elements[n62] = DenseDoubleMatrix1D.this.elements[n62] + dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (d == -1.0) {
                                for (int i = n5; i < n6; ++i) {
                                    int n7 = n9;
                                    DenseDoubleMatrix1D.this.elements[n7] = DenseDoubleMatrix1D.this.elements[n7] - dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    int n8 = n9;
                                    DenseDoubleMatrix1D.this.elements[n8] = DenseDoubleMatrix1D.this.elements[n8] + d * dArray[n22];
                                    n9 += DenseDoubleMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else {
                            for (int i = n5; i < n6; ++i) {
                                DenseDoubleMatrix1D.this.elements[n9] = doubleDoubleFunction.apply(DenseDoubleMatrix1D.this.elements[n9], dArray[n22]);
                                n9 += DenseDoubleMatrix1D.this.stride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            if (doubleDoubleFunction == DoubleFunctions.mult) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n7;
                    this.elements[n9] = this.elements[n9] * dArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (doubleDoubleFunction == DoubleFunctions.div) {
                for (int i = 0; i < this.size; ++i) {
                    int n10 = n7;
                    this.elements[n10] = this.elements[n10] / dArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                if (d == 0.0) {
                    return this;
                }
                if (d == 1.0) {
                    for (int i = 0; i < this.size; ++i) {
                        int n11 = n7;
                        this.elements[n11] = this.elements[n11] + dArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else if (d == -1.0) {
                    for (int i = 0; i < this.size; ++i) {
                        int n12 = n7;
                        this.elements[n12] = this.elements[n12] - dArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        int n13 = n7;
                        this.elements[n13] = this.elements[n13] + d * dArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.elements[n7] = doubleDoubleFunction.apply(this.elements[n7], dArray[n8]);
                    n7 += this.stride;
                    n8 += n2;
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n5; i < n6; ++i) {
                            if (DenseDoubleMatrix1D.this.elements[n2] != 0.0) {
                                ++n;
                            }
                            n2 += DenseDoubleMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[n7] != 0.0) {
                    ++n;
                }
                n7 += this.stride;
            }
        }
        return n;
    }

    public void dct(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct == null) {
            this.dct = new DoubleDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.forward(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dct.forward((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht == null) {
            this.dht = new DoubleDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.forward(this.elements);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dht.forward((double[])doubleMatrix1D.elements());
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst == null) {
            this.dst = new DoubleDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.forward(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dst.forward((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realForward(this.elements);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.fft.realForward((double[])doubleMatrix1D.elements());
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseDComplexMatrix1D getFft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        double[] dArray = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.size);
        double[] dArray2 = denseDComplexMatrix1D.elements();
        System.arraycopy(dArray, 0, dArray2, 0, this.size);
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        this.fft.realForwardFull(dArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix1D;
    }

    public DenseDComplexMatrix1D getIfft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        double[] dArray = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.size);
        double[] dArray2 = denseDComplexMatrix1D.elements();
        System.arraycopy(dArray, 0, dArray2, 0, this.size);
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        this.fft.realInverseFull(dArray2, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix1D;
    }

    public void getNonZeros(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            double d = this.elements[n2];
            if (d != 0.0) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            double d = this.elements[n2];
            if (d != 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            if ((d = this.elements[n2 += this.stride]) != 0.0) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            double d = this.elements[n2];
            if (d > 0.0) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            double d = this.elements[n2];
            if (d > 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            if ((d = this.elements[n2 += this.stride]) > 0.0) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
    }

    public void getNegativeValues(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            double d = this.elements[n2];
            if (d < 0.0) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            double d = this.elements[n2];
            if (d < 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            if ((d = this.elements[n2 += this.stride]) < 0.0) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    doubleArrayList.add(d);
                }
            }
            n2 += this.stride;
        }
    }

    public double[] getMaxLocation() {
        int n = 0;
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            double[][] dArray = new double[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        double d = DenseDoubleMatrix1D.this.elements[n];
                        int n2 = (n - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (!(d < DenseDoubleMatrix1D.this.elements[n += DenseDoubleMatrix1D.this.stride])) continue;
                            d = DenseDoubleMatrix1D.this.elements[n];
                            n2 = (n - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        }
                        return new double[]{d, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray[n3] = (double[])futureArray[n3].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(d < dArray[n3][0])) continue;
                    d = dArray[n3][0];
                    n = (int)dArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(d < this.elements[n7 += this.stride])) continue;
                d = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new double[]{d, n};
    }

    public double[] getMinLocation() {
        int n = 0;
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            double[][] dArray = new double[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        double d = DenseDoubleMatrix1D.this.elements[n];
                        int n2 = (n - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (!(d > DenseDoubleMatrix1D.this.elements[n += DenseDoubleMatrix1D.this.stride])) continue;
                            d = DenseDoubleMatrix1D.this.elements[n];
                            n2 = (n - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        }
                        return new double[]{d, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray[n3] = (double[])futureArray[n3].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(d > dArray[n3][0])) continue;
                    d = dArray[n3][0];
                    n = (int)dArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(d > this.elements[n7 += this.stride])) continue;
                d = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new double[]{d, n};
    }

    public double getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    public void idct(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct == null) {
            this.dct = new DoubleDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.inverse(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dct.inverse((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht == null) {
            this.dht = new DoubleDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.inverse(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dht.inverse((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst == null) {
            this.dst = new DoubleDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.inverse(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.dst.inverse((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realInverse(this.elements, bl);
        } else {
            DoubleMatrix1D doubleMatrix1D = this.copy();
            this.fft.realInverse((double[])doubleMatrix1D.elements(), bl);
            this.assign((double[])doubleMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DoubleMatrix1D like(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        final double[] dArray = (double[])((DoubleMatrix2D)denseDoubleMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseDoubleMatrix2D).index(0, 0);
        final int n4 = denseDoubleMatrix2D.rowStride();
        final int n5 = denseDoubleMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, this.size);
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseDoubleMatrix1D.this.zero + i * n * DenseDoubleMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                dArray[n6] = DenseDoubleMatrix1D.this.elements[n2];
                                n6 += n4;
                                n2 += DenseDoubleMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    dArray[n11] = this.elements[n10];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseDoubleMatrix2D;
    }

    public DoubleMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(n, n2, n3);
        final double[] dArray = (double[])((DoubleMatrix3D)denseDoubleMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseDoubleMatrix3D).index(0, 0, 0);
        final int n5 = denseDoubleMatrix3D.sliceStride();
        final int n6 = denseDoubleMatrix3D.rowStride();
        final int n7 = denseDoubleMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n8 = Math.min(n8, this.size);
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseDoubleMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseDoubleMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    dArray[n] = DenseDoubleMatrix1D.this.elements[n22];
                                    n += n6;
                                    n22 += DenseDoubleMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        dArray[n13] = this.elements[n12];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseDoubleMatrix3D;
    }

    public void setQuick(int n, double d) {
        this.elements[this.zero + n * this.stride] = d;
    }

    public void swap(DoubleMatrix1D doubleMatrix1D) {
        DenseDoubleMatrix1D denseDoubleMatrix1D;
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            super.swap(doubleMatrix1D);
        }
        if ((denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D) == this) {
            return;
        }
        this.checkSize(denseDoubleMatrix1D);
        final double[] dArray = denseDoubleMatrix1D.elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        final int n = (int)doubleMatrix1D.index(0);
        final int n2 = doubleMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDoubleMatrix1D.this.zero + n5 * DenseDoubleMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            double d = DenseDoubleMatrix1D.this.elements[n3];
                            DenseDoubleMatrix1D.this.elements[n3] = dArray[n22];
                            dArray[n22] = d;
                            n3 += DenseDoubleMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                double d = this.elements[n7];
                this.elements[n7] = dArray[n8];
                dArray[n8] = d;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(double[] dArray) {
        if (dArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, dArray, 0, this.elements.length);
        } else {
            super.toArray(dArray);
        }
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.zDotProduct(doubleMatrix1D, n, n2);
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        int n3 = n + n2;
        if (n < 0 || n2 < 0) {
            return 0.0;
        }
        if (this.size < n3) {
            n3 = this.size;
        }
        if (doubleMatrix1D.size() < (long)n3) {
            n3 = (int)doubleMatrix1D.size();
        }
        final double[] dArray = denseDoubleMatrix1D.elements;
        int n4 = (int)this.index(n);
        int n5 = (int)denseDoubleMatrix1D.index(n);
        int n6 = denseDoubleMatrix1D.stride;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        double d = 0.0;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n8;
            final int n9 = n4;
            final int n10 = n5;
            final int n11 = n6;
            n7 = Math.min(n7, n2);
            Future[] futureArray = new Future[n7];
            Double[] doubleArray = new Double[n7];
            int n12 = n2 / n7;
            for (n8 = 0; n8 < n7; ++n8) {
                final int n13 = n8 * n12;
                final int n14 = n8 == n7 - 1 ? n2 : n13 + n12;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int n = n9 + n13 * DenseDoubleMatrix1D.this.stride;
                        int n2 = n10 + n13 * n11;
                        n -= DenseDoubleMatrix1D.this.stride;
                        n2 -= n11;
                        double d = 0.0;
                        int n3 = n14 - n13;
                        int n4 = n3 / 4;
                        while (--n4 >= 0) {
                            int n5 = n + DenseDoubleMatrix1D.this.stride;
                            n = n5;
                            int n6 = n2 + n11;
                            n2 = n6;
                            int n7 = n + DenseDoubleMatrix1D.this.stride;
                            n = n7;
                            int n8 = n2 + n11;
                            n2 = n8;
                            n = n + DenseDoubleMatrix1D.this.stride;
                            n2 = n2 + n11;
                            d += DenseDoubleMatrix1D.this.elements[n5] * dArray[n6] + DenseDoubleMatrix1D.this.elements[n7] * dArray[n8] + DenseDoubleMatrix1D.this.elements[n] * dArray[n2] + DenseDoubleMatrix1D.this.elements[n += DenseDoubleMatrix1D.this.stride] * dArray[n2 += n11];
                        }
                        n4 = n3 % 4;
                        while (--n4 >= 0) {
                            d += DenseDoubleMatrix1D.this.elements[n += DenseDoubleMatrix1D.this.stride] * dArray[n2 += n11];
                        }
                        return d;
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n7; ++n8) {
                    doubleArray[n8] = (Double)futureArray[n8].get();
                }
                d = doubleArray[0];
                for (n8 = 1; n8 < n7; ++n8) {
                    d += doubleArray[n8].doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 -= this.stride;
            n5 -= n6;
            int n15 = n3 - n;
            int n16 = n15 / 4;
            while (--n16 >= 0) {
                int n17 = n4 + this.stride;
                n4 = n17;
                int n18 = n5 + n6;
                n5 = n18;
                int n19 = n4 + this.stride;
                n4 = n19;
                int n20 = n5 + n6;
                n5 = n20;
                n4 = n4 + this.stride;
                n5 = n5 + n6;
                d += this.elements[n17] * dArray[n18] + this.elements[n19] * dArray[n20] + this.elements[n4] * dArray[n5] + this.elements[n4 += this.stride] * dArray[n5 += n6];
            }
            n16 = n15 % 4;
            while (--n16 >= 0) {
                d += this.elements[n4 += this.stride] * dArray[n5 += n6];
            }
        }
        return d;
    }

    public double zSum() {
        double d = 0.0;
        final double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            Double[] doubleArray = new Double[n];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        int n = DenseDoubleMatrix1D.this.zero + n4 * DenseDoubleMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            d += dArray[n];
                            n += DenseDoubleMatrix1D.this.stride;
                        }
                        return d;
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    doubleArray[n2] = (Double)futureArray[n2].get();
                }
                d = doubleArray[0];
                for (n2 = 1; n2 < n; ++n2) {
                    d += doubleArray[n2].doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                d += dArray[n6];
                n6 += this.stride;
            }
        }
        return d;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        double[] dArray = this.elements;
        int n4 = this.size;
        while (--n4 >= 0 && n2 < n) {
            if (dArray[n3] != 0.0) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D selectedDenseDoubleMatrix1D = (SelectedDenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedDenseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == denseDoubleMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDoubleMatrix1D(this.elements, nArray);
    }
}

