/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tdouble;

import cern.colt.function.tdouble.DoubleLongProcedure;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tbyte.ByteArrayList;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.HashFunctions;
import cern.colt.map.tdouble.AbstractDoubleLongMap;

public class OpenDoubleLongHashMap
extends AbstractDoubleLongMap {
    private static final long serialVersionUID = 1L;
    protected double[] table;
    protected long[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenDoubleLongHashMap() {
        this(277);
    }

    public OpenDoubleLongHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenDoubleLongHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenDoubleLongHashMap openDoubleLongHashMap = (OpenDoubleLongHashMap)super.clone();
        openDoubleLongHashMap.table = (double[])openDoubleLongHashMap.table.clone();
        openDoubleLongHashMap.values = (long[])openDoubleLongHashMap.values.clone();
        openDoubleLongHashMap.state = (byte[])openDoubleLongHashMap.state.clone();
        return openDoubleLongHashMap;
    }

    public boolean containsKey(double d) {
        return this.indexOfKey(d) >= 0;
    }

    public boolean containsValue(long l) {
        return this.indexOfValue(l) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(DoubleProcedure doubleProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || doubleProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(DoubleLongProcedure doubleLongProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || doubleLongProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public long get(double d) {
        int n = this.indexOfKey(d);
        if (n < 0) {
            return 0L;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(double d) {
        double[] dArray = this.table;
        byte[] byArray = this.state;
        int n = dArray.length;
        int n2 = HashFunctions.hash(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && dArray[n3] != d) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(double d) {
        double[] dArray = this.table;
        byte[] byArray = this.state;
        int n = dArray.length;
        int n2 = HashFunctions.hash(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(long l) {
        long[] lArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] != 1 || lArray[n] != l) continue;
            return n;
        }
        return -1;
    }

    public double keyOf(long l) {
        int n = this.indexOfValue(l);
        if (n < 0) {
            return Double.NaN;
        }
        return this.table[n];
    }

    public void keys(DoubleArrayList doubleArrayList) {
        doubleArrayList.setSize(this.distinct);
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = dArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            dArray[n++] = dArray2[n2];
        }
    }

    public void pairsMatching(DoubleLongProcedure doubleLongProcedure, DoubleArrayList doubleArrayList, LongArrayList longArrayList) {
        doubleArrayList.clear();
        longArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !doubleLongProcedure.apply(this.table[n], this.values[n])) continue;
            doubleArrayList.add(this.table[n]);
            longArrayList.add(this.values[n]);
        }
    }

    public boolean put(double d, long l) {
        int n = this.indexOfInsertion(d);
        if (n < 0) {
            n = -n - 1;
            this.values[n] = l;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n2 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
            return this.put(d, l);
        }
        this.table[n] = d;
        this.values[n] = l;
        if (this.state[n] == 0) {
            --this.freeEntries;
        }
        this.state[n] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        double[] dArray = this.table;
        long[] lArray = this.values;
        byte[] byArray = this.state;
        double[] dArray2 = new double[n];
        long[] lArray2 = new long[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = dArray2;
        this.values = lArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.indexOfInsertion(d);
            dArray2[n4] = d;
            lArray2[n4] = lArray[n3];
            byArray2[n4] = 1;
        }
    }

    public boolean removeKey(double d) {
        int n = this.indexOfKey(d);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new double[n2];
        this.values = new long[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(LongArrayList longArrayList) {
        longArrayList.setSize(this.distinct);
        long[] lArray = longArrayList.elements();
        long[] lArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            lArray[n++] = lArray2[n2];
        }
    }
}

