% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_sc.R
\name{dist_sc}
\alias{dist_sc}
\title{Score-based distance matrix}
\usage{
dist_sc(scores_mat, scores_tbl, method_dist = "euclidean", ...)
}
\arguments{
\item{scores_mat}{A data frame or matrix containing the scores. This could be
the \code{$scores_matrix} output of the \code{\link{summary_sc}} function.}

\item{scores_tbl}{Deprecated argument from earlier version (0.1.0); scores_tbl
represented the output tibble from the \code{scoring} function.}

\item{method_dist}{Dissimilarity index used in the \code{vegdist} function
to calculate the dissimilarity matrix based on the scores.
Default is `euclidean`, for alternatives see \code{\link[vegan]{vegdist}}.}

\item{...}{Further arguments to be passed to the method \code{vegdist}.}
}
\value{
The function returns a \code{\link[stats]{dist}} object.
}
\description{
The function computes a distance matrix based on the \code{\link{scoring}} output
tibble (or the output tibble from the \code{\link{expect_resp}} function).
}
\examples{
# Using the Baltic Sea demo data
scores_tbl <- scoring(trend_tbl = model_trend_ex,
  mod_tbl = all_results_ex, press_type = press_type_ex)
scores_mat <- summary_sc(scores_tbl)$scores_matrix
dist_matrix <- dist_sc(scores_mat, method_dist = "euclidean")
}
\seealso{
\code{\link[vegan]{vegdist}} for the computation of the
dissimilarity index

Other score-based IND performance functions: \code{\link{clust_sc}},
  \code{\link{dist_sc_group}}, \code{\link{expect_resp}},
  \code{\link{plot_clust_sc}},
  \code{\link{plot_spiechart}}, \code{\link{scoring}},
  \code{\link{summary_sc}}
}
\concept{score-based IND performance functions}
