% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{AnnotateIDVCF}
\alias{AnnotateIDVCF}
\title{Add sequence context to an in-memory ID (insertion/deletion) VCF, and
  confirm that they match the given reference genome.}
\usage{
AnnotateIDVCF(ID.vcf, ref.genome, flag.mismatches = 0, name.of.VCF = NULL)
}
\arguments{
\item{ID.vcf}{An in-memory ID (insertion/deletion) VCF as a
\code{data.frame}. This function expects that there is a "context base" to
the left, for example REF = ACG, ALT = A (deletion of CG) or REF = A, ALT =
ACC (insertion of CC).}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{flag.mismatches}{Deprecated. If there are mismatches to references, the
function will automatically discard these rows. User can refer to the
element discarded.variants in the return value for more details.}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
A list whose first element "annotated.vcf" contains the original VCF data
  frame with 2 new columns added to the input data frame:
  \enumerate{ 
  \item \code{seq.context}
  The sequence embedding the variant.

  \item \code{seq.context.width} The width of \code{seq.context} to the left.
  }
  If there are rows that are discarded from the original VCF data frame, the
  function will generate a warning and a second element "discarded.variants"
  will be included in the return value. The discarded variants can belong to the 
  following types:
  \enumerate{
  \item Variants which have the same number of bases for REF and ALT alleles.
  \item Variants which have empty REF or ALT allels.
  \item Complex indels.
  \item Variants with mismatches between VCF and reference sequence.
  }
}
\description{
Add sequence context to an in-memory ID (insertion/deletion) VCF, and
  confirm that they match the given reference genome.
}
\examples{
file <- c(system.file("extdata/Strelka-ID-vcf/",
                      "Strelka.ID.GRCh37.s1.vcf",
                      package = "ICAMS"))
ID.vcf <- ReadStrelkaIDVCFs(file)[[1]]
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  list <- AnnotateIDVCF(ID.vcf, ref.genome = "hg19")
  annotated.ID.vcf <- list$annotated.vcf}
}
