% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biPlot.R
\name{biPlot}
\alias{biPlot}
\title{biPlot}
\usage{
biPlot(hM, etaPost, lambdaPost, factors = c(1, 2), colVar = NULL,
  colors = NULL, spNames = hM$spNames, ...)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{etaPost}{posterior distribution of site loadings (Eta)}

\item{lambdaPost}{posterior distribution of species loadings (Lambda)}

\item{factors}{indices of the two factors to be plotted}

\item{colVar}{the environmental covariate from XData according to which the sites are to be coloured}

\item{colors}{controls the colors of the heatmap. For continuous covariates, colors should be given as a palette, with default value \code{colorRampPalette(c("blue","white","red"))}. For factors, colors should be given as a list of colors, e.g. \code{c("blue","red")}.}

\item{spNames}{a vector of species names to be added to the ordination diagram}

\item{\dots}{other parameters passed to the function.}
}
\description{
Constructs an ordination biplot based on the fitted model
}
\examples{
# Construct an ordination biplot using two chosen latent factors from a previously fitted HMSC model
etaPost = getPostEstimate(TD$m, "Eta")
lambdaPost=getPostEstimate(TD$m, "Lambda")
biPlot(TD$m, etaPost = etaPost, lambdaPost=lambdaPost, factors=c(1,2))


}
