% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHANESsample.R
\docType{data}
\name{NHANESsample}
\alias{NHANESsample}
\title{A sample of data from the National Health and Nutrition Examination Survey
(NHANES)}
\format{
A data frame with 31,265 rows and 15 variables:
\describe{
  \item{ID}{Respondent sequence number ("SEQN" in NHANES)}
  \item{AGE}{Age ("RIDAGEYR" in NHANES: Best age in years of the sample
  person at time of HH screening. Individuals 85 and over are topcoded at 85
  years of age up to 2006 and individuals 80 and over are topcoded at 80
  years of age after 2006.)}
  \item{SEX}{Gender ("RIAGENDR" in NHANES)}
  \item{RACE}{Race and ethnicity ("RIDRETH1" in NHANES)}
  \item{EDUCATION}{Education Level ("DMDEDUC2" in NHANES: What is the highest
   grade or level of school you have completed or the highest degree you have
   received?)}
  \item{INCOME}{Poverty income ratio (PIR): a ratio of family income to
  poverty threshold ("INDFMPIR" in NHANES)}
  \item{SMOKE}{Smoking status (Combination of SMQ020 (Have you smoked at
  least 100 cigarettes in your entire life?) and SMQ040 (Do you now smoke
  cigarettes?) in NHANES: equal to "Still Smoke" if respondent answered
  "Yes" to SMQ020 and either "Every day" or "Some days" to SMQ040, equal to
  "Quit Smoke" if respondent answered "Yes" to SMQ020 and "Not at all" to
  SMQ040, and equal to "Never Smoke" otherwise.)}
  \item{YEAR}{Year of the Study (Equal to the first year of the two year
  interval in which the response was recorded - NHANES surveys are grouped
  in two-year intervals)}
  \item{LEAD}{Lead (ug/dL): "LBXBPB" in NHANES unless the reported level of
  lead was less than the lower limit of detection (llod), as defined by the
  paper cited above, for the relevant year, in which case "LBXBPB" was
  replaced by llod/sqrt(2))}
  \item{BMI_CAT}{Body Mass Index Category (kg/m^2): Based on "BMXBMI" in
  NHANES}
  \item{LEAD_QUANTILE}{Quantile membership for blood lead levels based on
  the distribution of lead levels in the data}
  \item{HYP}{Hypertension Status: Based on "BPQ020" (Have you ever been told
  by a doctor or other health professional that you had hypertension,
  also called high blood pressure?) and "BPQ040A" (Because of your high blood
  pressure/hypertension, have you ever been told to take prescribed
  medicine?) in NHANES. Equal to 1 if the respondent answered "Yes" to either
  of these questions, or, if data on either of these questions isn't answered,
  if SBP >= 130 or DBP >= 80, and equal to 0 otherwise.}
  \item{ALC}{Alcohol Use: Based on "ALQ120Q" (In the past 12 months, how
  often did you drink any type of alcoholic beverage?) up to 2016
  and "ALQ121" (the same question, but used after 2016) in NHANES. Equal to
  "Yes" if the respondent's answer to either of these questions was > 0 and
  equal to "No" otherwise.}
  \item{DBP1}{First Diastolic Blood Pressure (mmHg) reading:
  "BPXDI1" in NHANES.}
  \item{DBP2}{Second Diastolic Blood Pressure (mmHg) reading:
  "BPXDI2" in NHANES.}
  \item{DBP3}{Third Diastolic Blood Pressure (mmHg) reading:
  "BPXDI3" in NHANES.}
  \item{DBP4}{Fourth Diastolic Blood Pressure (mmHg) reading:
  "BPXDI4" in NHANES.}
  \item{SBP1}{First Systolic Blood Pressure (mmHg) reading:
  "BPXSY1" in NHANES.}
  \item{SBP2}{Second Systolic Blood Pressure (mmHg) reading:
  "BPXSY2" in NHANES.}
  \item{SBP3}{Third Systolic Blood Pressure (mmHg) reading:
  "BPXSY3" in NHANES.}
  \item{SBP4}{Fourth Systolic Blood Pressure (mmHg) reading:
  "BPXSY4" in NHANES.}
}
}
\source{
Data was obtained from the nhanesA package
\url{https://CRAN.R-project.org/package=nhanesA}.

Variable selection and feature engineering were conducted in an effort to
replicate the analyses conducted by

Huang, Z. (2022). Association Between Blood Lead Level With High Blood
Pressure in US (NHANES 1999-2018). Frontiers in Public Health, 892.

\url{https://www.frontiersin.org/articles/10.3389/fpubh.2022.836357/full}.
}
\usage{
NHANESsample
}
\description{
Lead, blood pressure, and demographic variables from NHANES 1999-2018,
downloaded from the nhanesA package. Data was filtered to adults 20 years of
age or older with nonmissing blood lead level, blood pressure, and
demographic information.
}
\keyword{datasets}
