% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/port_reactions.R
\name{port_reactions}
\alias{port_reactions}
\title{Port GillespieSSA parameters to GillespieSSA2}
\usage{
port_reactions(x0, a, nu)
}
\arguments{
\item{x0}{The \code{x0} parameter of \code{\link[GillespieSSA:ssa]{GillespieSSA::ssa()}}.}

\item{a}{The \code{a} parameter of \code{\link[GillespieSSA:ssa]{GillespieSSA::ssa()}}.}

\item{nu}{The \code{nu} parameter of \code{\link[GillespieSSA:ssa]{GillespieSSA::ssa()}}.}
}
\value{
A set of \code{\link[=reaction]{reaction()}}s to be used by \code{\link[=ssa]{ssa()}}.
}
\description{
This is a helper function to tranform GillesieSSA-style
paramters to GillespieSSA2.
}
\examples{
x0  <- c(Y1 = 1000, Y2 = 1000)
a   <- c("c1*Y1","c2*Y1*Y2","c3*Y2")
nu  <- matrix(c(+1,-1,0,0,+1,-1),nrow=2,byrow=TRUE)
port_reactions(x0, a, nu)
}
