% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_server.R
\name{app_server}
\alias{app_server}
\alias{GenEstServer}
\alias{reaction}
\alias{reactionMessageRun}
\alias{reactionMessageDone}
\alias{eventReaction}
\title{The GenEst server definition function}
\usage{
GenEstServer(input, output, session)

reaction(eventName)

reactionMessageRun(eventName)

reactionMessageDone(eventName)

eventReaction(eventName, rv, input, output, session)
}
\arguments{
\item{input}{\code{input} list for the GenEst GUI.}

\item{output}{\code{output} list for the GenEst GUI.}

\item{session}{Environment for the GenEst GUI.}

\item{eventName}{Character name of the event. One of "clear_all",
"file_SE", "file_SE_clear", "file_CP", "file_CP_clear", "file_SS",
"file_SS_clear", "file_DWP", "file_DWP_clear", "file_CO",
"file_CO_clear", "class", "obsSE", "predsSE", "run_SE", "run_SE_clear",
"outSEclass", "outSEp", "outSEk", "ltp", "fta", "predsCP", "run_CP",
"run_CP_clear", "outCPclass", "outCPdist", "outCPl", "outCPs",
"run_M", "run_M_clear", "split_M", "split_M_clear", "transpose_split",
"run_g", "run_g_clear", or "outgclass".}

\item{rv}{reactive variable}
}
\description{
This suite of functions defines the server-side program for
  the GenEst user interface (UI). See the "GenEst Graphic User Interface"
  vignette for a more complete detailing of the codebase underlying
  the GenEst UI. \cr \cr \code{GenEstServer}: main server function
  expressed within the application.
}
\details{
\code{GenEstServer} is used as the main server function, and is
  therefore included in the \code{server.R} script of the app. This 
  function is not used in a standard R function sense, in that it does
  not return a value and is not used on its own to have side effects.
  The code of the function has two parts: 
  \enumerate{
    \item preamble that defines all the necessary variables and options
    \item \code{\link[shiny]{observeEvent}} calls, one for each event in
      the application. Each call to \code{\link[shiny]{observeEvent}} 
      includes the \code{eventExpr} (event expression) as the first 
      argument and the \code{handlerExpr} (handler expression) as the 
      second argument, which is an evaluated (via \code{\link[base]{eval}})
      block of code returned from \code{reaction} for the specific 
      event, as well as any other control switch arguments needed (such as
      \code{ignoreNULL}). 
  }
}
