% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carcass_persistence_functions.R
\name{rcp}
\alias{rcp}
\title{Simulate parameters from a fitted cp model}
\usage{
rcp(n, model, type = "survreg")
}
\arguments{
\item{n}{the number of simulation draws}

\item{model}{A \code{cpm} object (which is returned from 
\code{\link{cpm}})}

\item{type}{The type of parameters requested. \code{"survreg"} or 
\code{"ppersist"}}
}
\value{
list of two matrices of \code{n} simulated \code{l} and \code{s}
  (if \code{type = "survreg"}) or \code{a} and \code{b} (if \code{type = 
  "ppersist"})for cells defined by the \code{model} object.
}
\description{
Simulate parameters from a \code{\link{cpm}} model object, and 
  format them as either type \code{"survreg"} or \code{"ppersist"}
}
\examples{
  data(wind_RP)
  mod <- cpm(formula_l = l ~ 1, data = wind_RP$CP, left = "LastPresent",
           right = "FirstAbsent"
         )
  rcp(n = 10, model = mod, type = "survreg")
  rcp(n = 10, model = mod, type = "ppersist")

}
