% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_figure_functions.R
\name{plot.gGeneric}
\alias{plot.gGeneric}
\title{Plot results of a single generic ghat estimation}
\usage{
\method{plot}{gGeneric}(x, CL = 0.9, ...)
}
\arguments{
\item{x}{\code{\link{estgGeneric}} output}

\item{CL}{confidence level to use}

\item{...}{to be passed down}
}
\value{
generic detection probability plot
}
\description{
Plot method for a single generic \code{ghat} estimation
}
\examples{
  data(mock)
  model_SE <- pkm(formula_p = p ~ HabitatType, formula_k = k ~ 1,
                data = mock$SE)
  model_CP <- cpm(formula_l = l ~ Visibility, formula_s = s ~ Visibility, 
                data = mock$CP, left = "LastPresentDecimalDays", 
                right = "FirstAbsentDecimalDays")
  avgSS <- averageSS(mock$SS)
  ghatsGeneric <- estgGeneric(nsim = 1000, avgSS, model_SE, model_CP)
  plot(ghatsGeneric)

}
