% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits_functions.R
\name{calcRate}
\alias{calcRate}
\title{Estimate the number of fatalities in each search interval throughout
  the monitoring period.}
\usage{
calcRate(M, Aj, days = NULL, searches_carcass = NULL, data_SS = NULL)
}
\arguments{
\item{M}{Numeric array (ncarc x nsim) of estimated number of fatalities
by observed carcass and simulation rep}

\item{Aj}{Integer array (ncarc x nsim) of simulated arrival intervals for
each observed carcass. Arrival intervals are given as integers j, 
indicating that the given carcass (indexed by row) arrived in the jth
search interval in the given simulation rep (indexed by column). Arrival 
interval indices (j) are relative to indexed carcasses' search schedules.}

\item{days}{Vector of all dates that at least one unit was searched. Format
is the number of days since the first search. For example, days = c(0, 7,
14, 28, 35) for a simple 7-day search schedule in which searches were
conducted every once per week on the same day for 5 weeks. Not all units
need be searched on every search date.}

\item{searches_carcass}{An ncarc x length(days) array of 0s and 1s to 
indicate searches in which the indexed carcass could have been found. 
For example, row i = \code{c(1, 0, 1, 0, 1)} indicates that the search 
schedule for the location (unit) where carcass i was found would be 
\code{days[c(1, 3, 5)]}.}

\item{data_SS}{\code{\link{prepSS}} object that contains formatted data for
calculating splits. Optional argument. Alternatively, user may provide 
\code{days} and \code{searches_carcass}.}
}
\value{
Numeric array (nsim x nsearch) of estimated fatalities in each
  search interval. NOTE: The search at time t = 0 does not correspond to an
  interval, and all carcasses found at that time are assumed to have 
  arrived prior to the monitoring period and are not included in mortality 
  estimates so \code{nsearch = length(days) - 1}.
}
\description{
A carcass that is observed in a given search may have arrived 
  at any time prior to that search, so carcass discovery time is often not
  a reliable estimate of carcass arrival time. For each observed carcass, 
  \code{calcRate} takes into account the estimated probability of arrival
  in each possible arrival interval, adjusts by detection probability, and 
  sums to estimate the estimated number of carcass arrivals in every search
  interval.
}
