% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_product.R
\docType{class}
\name{kernel_product}
\alias{kernel_product}
\title{Gaussian Kernel R6 class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Gaussian Kernel R6 class

Gaussian Kernel R6 class
}
\examples{
k1 <- Exponential$new(beta=1)
k2 <- Matern32$new(beta=2)
k <- k1 * k2
k$k(matrix(c(2,1), ncol=1))
}
\section{Super class}{
\code{\link[GauPro:GauPro_kernel]{GauPro::GauPro_kernel}} -> \code{GauPro_kernel_product}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{k1}}{kernel 1}

\item{\code{k2}}{kernel 2}

\item{\code{s2}}{Variance}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{k1pl}}{param length of kernel 1}

\item{\code{k2pl}}{param length of kernel 2}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_product-new}{\code{kernel_product$new()}}
\item \href{#method-GauPro_kernel_product-k}{\code{kernel_product$k()}}
\item \href{#method-GauPro_kernel_product-param_optim_start}{\code{kernel_product$param_optim_start()}}
\item \href{#method-GauPro_kernel_product-param_optim_start0}{\code{kernel_product$param_optim_start0()}}
\item \href{#method-GauPro_kernel_product-param_optim_lower}{\code{kernel_product$param_optim_lower()}}
\item \href{#method-GauPro_kernel_product-param_optim_upper}{\code{kernel_product$param_optim_upper()}}
\item \href{#method-GauPro_kernel_product-set_params_from_optim}{\code{kernel_product$set_params_from_optim()}}
\item \href{#method-GauPro_kernel_product-dC_dparams}{\code{kernel_product$dC_dparams()}}
\item \href{#method-GauPro_kernel_product-C_dC_dparams}{\code{kernel_product$C_dC_dparams()}}
\item \href{#method-GauPro_kernel_product-dC_dx}{\code{kernel_product$dC_dx()}}
\item \href{#method-GauPro_kernel_product-s2_from_params}{\code{kernel_product$s2_from_params()}}
\item \href{#method-GauPro_kernel_product-print}{\code{kernel_product$print()}}
\item \href{#method-GauPro_kernel_product-clone}{\code{kernel_product$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel" data-id="plot"><a href='../../GauPro/html/GauPro_kernel.html#method-GauPro_kernel-plot'><code>GauPro::GauPro_kernel$plot()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-new}{}}}
\subsection{Method \code{new()}}{
Is s2 being estimated?


Length of the parameters of k1


Length of the parameters of k2


Initialize kernel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$new(k1, k2, useC = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k1}}{Kernel 1}

\item{\code{k2}}{Kernel 2}

\item{\code{useC}}{Should C code used? Not applicable for kernel product.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-k"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-k}{}}}
\subsection{Method \code{k()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$k(x, y = NULL, params, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector, optional. If excluded, find correlation
of x with itself.}

\item{\code{params}}{parameters to use instead of beta and s2.}

\item{\code{...}}{Not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-param_optim_start"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-param_optim_start}{}}}
\subsection{Method \code{param_optim_start()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$param_optim_start(jitter = F, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-param_optim_start0"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-param_optim_start0}{}}}
\subsection{Method \code{param_optim_start0()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$param_optim_start0(jitter = F, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-param_optim_lower"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-param_optim_lower}{}}}
\subsection{Method \code{param_optim_lower()}}{
Lower bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$param_optim_lower()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-param_optim_upper"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-param_optim_upper}{}}}
\subsection{Method \code{param_optim_upper()}}{
Upper bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$param_optim_upper()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-set_params_from_optim"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-set_params_from_optim}{}}}
\subsection{Method \code{set_params_from_optim()}}{
Set parameters from optimization output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$set_params_from_optim(optim_out)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optim_out}}{Output from optimization}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-dC_dparams}{}}}
\subsection{Method \code{dC_dparams()}}{
Derivative of covariance with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$dC_dparams(params = NULL, C, X, C_nonug, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{C}}{Covariance with nugget}

\item{\code{X}}{matrix of points in rows}

\item{\code{C_nonug}}{Covariance without nugget added to diagonal}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-C_dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-C_dC_dparams}{}}}
\subsection{Method \code{C_dC_dparams()}}{
Calculate covariance matrix and its derivative
 with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$C_dC_dparams(params = NULL, X, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-dC_dx"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-dC_dx}{}}}
\subsection{Method \code{dC_dx()}}{
Derivative of covariance with respect to X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$dC_dx(XX, X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{matrix of points}

\item{\code{X}}{matrix of points to take derivative with respect to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-s2_from_params"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-s2_from_params}{}}}
\subsection{Method \code{s2_from_params()}}{
Get s2 from params vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$s2_from_params(params, s2_est = self$s2_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{parameter vector}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_product-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_product-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{kernel_product$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
