% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoregressor.BGLR.multikinships}
\alias{phenoregressor.BGLR.multikinships}
\title{Multi-matrix GBLUP using BGLR}
\usage{
phenoregressor.BGLR.multikinships(
  phenotypes,
  genotypes = NULL,
  covariances,
  extraCovariates,
  type = "RKHS",
  ...
)
}
\arguments{
\item{phenotypes}{phenotypes, a numeric array (n x 1), missing values are predicted}

\item{genotypes}{added for compatibility with the other GROAN regressors, must be NULL}

\item{covariances}{square matrix (n x n) of covariances.}

\item{extraCovariates}{the extra covariance matrices to be added in the GBLUP model,
collated in a single matrix-like structure, with optionally first column
as an ignored intercept (supported for compatibility). See details, below.}

\item{type}{character literal, one of the following: FIXED (Flat prior), BRR (Gaussian prior),
BL (Double-Exponential prior), BayesA (scaled-t prior),
BayesB (two component mixture prior with a point of mass at zero and a scaled-t slab),
BayesC (two component mixture prior with a point of mass at zero and a Gaussian slab),
RKHS (Gaussian processes, default)}

\item{...}{extra parameters are passed to \code{\link[BGLR]{BGLR}}}
}
\value{
The function returns a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (n) predicted phenotypes, with NAs filled and all other positions repredicted (useful for calculating residuals)
  \item \code{hyperparams} : empty, returned for compatibility
  \item \code{extradata}   : list with information on trained model, coming from \code{\link[BGLR]{BGLR}}
}
}
\description{
This regressor implements Genomic BLUP using Bayesian methods from \link[BGLR]{BGLR} package,
but allows to use more than one covariance matrix.
}
\details{
In its simplest form, GBLUP is defined as:
\deqn{y = 1\mu + Z u + e}
with
\deqn{var(y) =  K \sigma_u^2 + I\sigma_e^2}

Where \eqn{\mu} is the overall mean, \eqn{K} is the incidence matrix
relating individual weights \eqn{u} to \eqn{y}, and \eqn{e} is a
vector of residuals with zero mean and covariance matrix \eqn{I\sigma_e^2}

It is possible to extend the above model to include different types of
kinship matrices, each capturing different links between genotypes and phenotypes:

\deqn{y = 1\mu + Z1 u1 + Z2 u2 + \dots + e}
with
\deqn{var(y) =  K1 \sigma_u1^2 + K2 \sigma_u2^2 + \dots + I\sigma_e^2}

This function receives the first kinship matrix \eqn{K1} via the \code{covariances}
argument and an arbitrary number of extra matrices via the \code{extraCovariates}
built as follow:

 \preformatted{#given the following defined variables
y = <some values, Nx1 array>
K1 = <NxN kinship matrix>
K2 = <another NxN kinship matrix>
K3 = <a third NxN kinship matrix>

#invoking the multi kinship GBLUP
y_hat = phenoregressor.BGLR.multikinships(
  phenotypes = y,
  covariances = K1,
  extraCovariates = cbind(K2, K3)
)
}
}
\seealso{
\link[BGLR]{BGLR}

Other phenoRegressors: 
\code{\link{phenoRegressor.BGLR}()},
\code{\link{phenoRegressor.RFR}()},
\code{\link{phenoRegressor.SVR}()},
\code{\link{phenoRegressor.dummy}()},
\code{\link{phenoRegressor.rrBLUP}()}
}
\concept{phenoRegressors}
