% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_prediction.R
\name{vecchia_prediction}
\alias{vecchia_prediction}
\title{Vecchia prediction}
\usage{
vecchia_prediction(
  z,
  vecchia.approx,
  covparms,
  nuggets,
  var.exact,
  covmodel = "matern",
  return.values = "all"
)
}
\arguments{
\item{z}{observed data}

\item{vecchia.approx}{a vecchia object as generated by vecchia_specify()}

\item{covparms}{covariance parameters as a vector}

\item{nuggets}{nugget}

\item{var.exact}{should prediction variances be computed exactly, or is a (faster) approximation acceptable}

\item{covmodel}{covariance model, 'matern' by default.}

\item{return.values}{either 'mean' only, 'meanvar', 'meanmat', or 'all'}
}
\value{
posterior mean and variances at observed and unobserved locations; V matrix
}
\description{
Vecchia prediction
}
\examples{
z=rnorm(5); locs=matrix(1:5,ncol=1); vecchia.approx=vecchia_specify(locs,m=3,locs.pred=locs+.5)
vecchia_prediction(z,vecchia.approx,covparms=c(1,2,.5),nuggets=.2)
}
