% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegularNode.R
\name{Level2RegularNodeCC}
\alias{Level2RegularNodeCC}
\title{Regular nodes from a GO CC level}
\usage{
Level2RegularNodeCC(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{Organism of interest that is supported by the package}
}
\value{
Regular nodes from the GO-level
}
\description{
The function retrieves the Regular nodes (RNs) from a GO-level. RNs are those GO-terms which have all their
             children in the next GO-level (i.e level = level of parent + 1).
             If the optional parameter "organism" is missing
             then the result will be from the general GO tree instead of from a particular organism. The supported organisms
              are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Regualar nodes on level 5
Level2RegularNodeCC(level = 5, organism = "Yeast")

# Regular nodes on level 9
Level2RegularNodeCC(level = 9, organism = "Rat")

}
