% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JumpNode.R
\name{Level2JumpNodeCC}
\alias{Level2JumpNodeCC}
\title{Jump nodes from a GO CC level}
\usage{
Level2JumpNodeCC(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{Organism of interest that is supported by the package}
}
\value{
All jump nodes from the level
}
\description{
The function retrieves the Jump nodes (JNs) from a GO-level. JNs are those GO-terms which have at least
              one child term not present in the level below it. If the optional parameter "organism" is missing then
              the result are from the general GO tree. The supported organisms are "Homo sapiens / Human",
              "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
              "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
              "Schizosaccharomyces pombe / Fission yeast",
              "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Jump nodes on level 5
Level2JumpNodeCC(level = 5, organism = "Saccharomyces cerevisiae" )

# Jump nodes on level 3
Level2JumpNodeCC(level = 3, organism = "Schizosaccharomyces pombe" )
}
