% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportedOrganism.R
\name{visRDAGMF}
\alias{visRDAGMF}
\title{Species-specific molecular function GO-DAG}
\usage{
visRDAGMF(organism, plot = TRUE)
}
\arguments{
\item{organism}{The organism supported by the package. Both the scientific / common name of the organism can be
use to derive the Sub-DAG.  If this argument is "MF" the reduced MF GO-DAG is visualised.}

\item{plot}{If TRUE, both the reduced DAG and the GO-terms contained in each node is derived}
}
\value{
A list containing the plot of the DAG and all the GO terms presents in each node
}
\description{
A sub-dag of molecular function terms for a certain species e.g DAG of the gene association GO-terms for
             Arabidopsis thaliana. The label "J","R" and "L" on the right side of the plot
             gives the number of connections between the regular node (RN) on the level and the
             nodes right below it (RN are nodes that have all their children nodes represented in the next level).
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
            "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{

# Reduced GO-DAG for Zebrafish
visRDAGMF(organism = "Zebrafish")

# Reduced GO-DAG for Caenorhabditis elegans
visRDAGMF(organism = "Caenorhabditis elegans")

# RN GO-terms on level 1 can be access as follows
visRDAGMF(organism = "Caenorhabditis elegans", plot = FALSE)$"L1 RN"

# JN GO-terms on level 9 can be access as follows
visRDAGMF(organism = "Caenorhabditis elegans", plot = FALSE)$"L9 JN"

# LN GO-terms on level 14 can be access as follows
visRDAGMF(organism = "Caenorhabditis elegans", plot = FALSE)$"L14 LN"
}
