% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Delta_DMC_test.R
\name{deltadmc.test}
\alias{deltadmc.test}
\title{Statistical test for Delta DMC Multiple Detrended Cross-Correlation Coefficient}
\usage{
deltadmc.test(x1, x2, y, k, nu, rep, method)
}
\arguments{
\item{x1}{A vector containing univariate time series.}

\item{x2}{A vector containing univariate time series.}

\item{y}{A vector containing univariate time series.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{nu}{An integer value. See the DCCA package.}

\item{rep}{An integer value indicating the number of repetitions.}

\item{method}{A character string indicating which correlation coefficient is to be used. If method = "rhodcca" the dmc coefficient is generated from the DCCA coefficient. If method = "dmca", the dmc coefficient is generated from the DMCA coefficient.}
}
\value{
An list containing "timescale" "dmc_before", "dmc_after", "deltadmc", "CI_0.90", "CI_0.95", "CI_0.99".
}
\description{
This function performs the statistical test for Delta DMC cross-correlation coefficient from three univariate ARFIMA process.
}
\details{
This function include following measures: timescale, dmc_before, dmc_after, deltadmc
}
\examples{
x1 <- rnorm(1000)
x2 <- rnorm(1000)
y <-  rnorm(1000)
deltadmc.test(x1,x2,y, k=100, nu=0, rep=10, method="rhodcca")

}
\references{
ZEBENDE, G.F.; SILVA-FILHO, A.M. Detrended Multiple Cross-Correlation Coefficient. PHYSICA A, v.510, p.91-97, 2018.

SILVA-FILHO,A.M; ZEBENDE,G.; CASTRO,A.P.; GUEDES,E. Statistical test for multiple detrended cross-correlation coefficient, Physica A, v.562, 125285, 2021.

KRISTOUFEK, L. Detrending moving-average cross-correlation coefficient: Measuring cross-correlations between non-stationary series. PHYSICA A, v.406, p.169-175, 2014.
}
