% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCols.R
\name{summariseCols}
\alias{summariseCols}
\title{Perform summary of vectors in the parent frame}
\usage{
summariseCols(colfun, nfr = 3L)
}
\arguments{
\item{colfun}{a character matrix with two columns.
The first should be a function name, the second a column in data.}

\item{nfr}{single positive integer number of frames up to look for named variables (default 3)}
}
\value{
data frame with column names constructed from colfun
}
\description{
Parses a matrix of object/summary instructions,
and applies the specified function to the object.
The object(s) named in colfun must exist in a parent frame.
}
\examples{
A <- split(1:10, rep(1, each = 10))
dataCols <- matrix(c("A", "mean",
        "A", "median",
        "A", "var"), ncol = 2, byrow = TRUE)
GENEAclassify:::summariseCols(colfun = dataCols)
A <- split(1:10, rep(1:2, each = 5))
GENEAclassify:::summariseCols(colfun = dataCols)
}
\keyword{internal}
