% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeTimes.R
\name{changeTimes}
\alias{changeTimes}
\title{Select Times as Segment Changepoints}
\usage{
changeTimes(
  time,
  intervalseconds = 30,
  changeupdown,
  changedegrees,
  mininterval = 5,
  verbose = TRUE,
  verbose_timer = TRUE
)
}
\arguments{
\item{time}{numeric vector}

\item{intervalseconds}{An integer number of seconds (usually greater than 5) 
during which at most one changepoint may occur (typically between 5 and 30).
If intervalseconds is NA, all times will be returned.
If intervalseconds <= mininterval it will be ignored 
(with a warning if verbose is \code{TRUE})}

\item{changeupdown}{cpt object}

\item{changedegrees}{cpt object}

\item{mininterval}{single numeric}

\item{verbose}{single logical should all warnings be reported? (default TRUE)}

\item{verbose_timer}{single logical giving a time analysis of code.}
}
\value{
numeric vector of times
}
\description{
Trims down the number of changepoints in time series 
data to give segments that can reasonably be classified into 
discrete periods of activity. These will not normally be less than
30 seconds in duration.
}
\details{
The \pkg{changepoint} package provides tools for optimally 
segmenting time series data.
}
\examples{

library(changepoint)
d1 <- c(54, 30, 27, 53, 100, 204, 197)
d2 <- c(67, 64, 70, 79, 69, 60, 54)
c1 <- cpt.var(d1, penalty = "SIC", pen.value = 1e-3, method = "PELT")
c2 <- cpt.var(d2, penalty = "SIC", pen.value = 1e-3, method = "PELT")
changeTimes(time = 0:6, intervalseconds = 30, 
    changeupdown = c1, changedegrees = c2)
}
\keyword{internal}
