% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemOLGPureExchange_2_2.R
\name{gemOLGPureExchange_2_2}
\alias{gemOLGPureExchange_2_2}
\title{The Basic Overlapping Generations pure exchange Model (see Samuelson, 1958)}
\usage{
gemOLGPureExchange_2_2(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
This is the basic overlapping generations pure exchange model.
}
\details{
As Samuelson (1958) wrote, break each life up into thirds.
Agents get one unit of payoff in period 1 and one unit in period 2; in period 3 they retire and get nothing.
Suppose there are three agents in each period, namely age1, age2 and age3.
In the next period, the present age1 will become age2, the present age2 will become age3,
the present age3 will disappear and a new age1 will appear.
Let c1, c2 and c3 denote the consumption of an agent in each period.
Suppose the utility function is (c1 * c2 * c3)^(1 / 3), which is actually the same as log(c1) + log(c2) + log(c3).
In each period, age1 and age2 will exchange their payoffs of the present period and the next period.
Age2 will sell some present payoff and buy some future payoff as pension, and age1 quite the contrary.
Age3 just takes away the pension and need not take part in the exchange.
Hence there are only two agents in the pure exchange economy.
In the present exchange process, the utility function of age1 is c1^(1 / 3) * x2^(2 / 3), wherein x2 is the revenue of the next period,
and the utility function of age2 is c2^(1 / 2) * c3^(1 / 2).
}
\note{
We can also suppose only age2 gets payoff and age1 does not.
}
\examples{
\donttest{
#### the basic overlapping generations (inefficient) exchange model
dst.age1 <- node_new(
  "util",
  type = "CD", alpha = 1, beta = c(1 / 3, 2 / 3),
  "payoff1", "payoff2"
)

dst.age2 <- node_new(
  "util",
  type = "CD", alpha = 1, beta = c(1 / 2, 1 / 2),
  "payoff1", "payoff2"
)

ge <- sdm2(
  A = list(dst.age1, dst.age2),
  B = matrix(0, 2, 2),
  S0Exg = matrix(c(
    1, 1,
    1, 0
  ), 2, 2, TRUE),
  names.commodity = c("payoff1", "payoff2"),
  names.agent = c("age1", "age2"),
  numeraire = "payoff1",
  policy = function(time, state) {
    pension <- (state$last.A[, 2] * state$last.z[2])[2]
    if (time > 1) state$S[1, 2] <- 1 - pension
    state
  }
)

ge$p # c(1, 3 / 2 + sqrt(13) / 2)
ge$S
ge$D
ge$DV

#### another calculation method for the first economy
n <- 18 # the number of agents. The number of payoff types is n+2.
payoff.age2 <- 1
payoff.age3 <- 1e-10
S <- diag(1, n + 2, n)
S <- S + rbind(0, diag(payoff.age2, n + 1, n)) + rbind(0, 0, diag(payoff.age3, n, n))

dstl <- list()
for (k in 1:n) {
  dstl[[k]] <- node_new(
    "util",
    type = "CD", alpha = 1,
    beta = c(1 / 3, 1 / 3, 1 / 3),
    paste0("payoff", k), paste0("payoff", k + 1), paste0("payoff", k + 2)
  )
}

ge <- sdm2(
  A = dstl,
  B = matrix(0, n + 2, n, TRUE),
  S0Exg = S,
  names.commodity = paste0("payoff", 1:(n + 2)),
  numeraire = "payoff1"
)

growth_rate(ge$p) + 1    # 3 / 2 + sqrt(13) / 2
ge$D

}

}
\references{
Samuelson, P. A. (1958) An Exact Consumption-Loan Model of Interest with or without the Social Contrivance of Money. Journal of Political Economy, vol. 66(6): 467-482.
}
\seealso{
{
\code{\link{gemOLGTimeCircle}}
}
}
