% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_add_by_name.R
\name{matrix_add_by_name}
\alias{matrix_add_by_name}
\title{Add Matrices by Names of Columns and Rows}
\usage{
matrix_add_by_name(M, ...)
}
\arguments{
\item{M}{a matrix with column names and row names.}

\item{...}{some matrices with column names and row names which constitute subsets of those of M.
If there is a vector, it will be converted to a matrix of one column and the column will be named after the vector.}
}
\value{
A matirx.
}
\description{
Add together some matrices by names of columns and rows.
Those matrices may have distinct sizes. All matrices should not have column names and row names other than those of the first matrix.
}
\examples{
M <- matrix(0, 5, 5)
colnames(M) <- paste("c", as.character(1:5), sep = "")
rownames(M) <- paste("r", as.character(1:5), sep = "")

M2 <- matrix(1:9, 3, 3)
colnames(M2) <- c("c2", "c3", "c5")
rownames(M2) <- c("r1", "r2", "r4")

matrix_add_by_name(M, M2)

c1 <- c(r1 = 1, r3 = 2)
matrix_add_by_name(M, c1)
matrix_add_by_name(M, c1, M2)
}
