% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAYMET_FUNCTIONS.R
\name{get_daymet_tile}
\alias{get_daymet_tile}
\title{Download and crop a netcdf tile from the 1-km DAYMET daily weather dataset.}
\usage{
get_daymet_tile(template, tileID, elements = NULL, years = NULL, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping. If missing, entire tile is returned.}

\item{tileID}{A numeric indicating the DAYMET tile ID number.}

\item{elements}{A character vector of elemets to extract.\cr
The available elements are:\cr
dayl = Duration of the daylight period in seconds per day. This calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.\cr
prcp = Daily total precipitation in millimeters per day, sum of all forms converted to water-equivalent. Precipitation occurrence on any given day may be ascertained.\cr
srad = Incident shortwave radiation flux density in watts per square meter, taken as an average over the daylight period of the day. NOTE: Daily total radiation (MJ/m2/day) can be calculated as follows: ((srad (W/m2) * dayl (s/day)) / l,000,000)\cr
swe = Snow water equivalent in kilograms per square meter. The amount of water contained within the snowpack.\cr
tmax = Daily maximum 2-meter air temperature in degrees Celsius.\cr
tmin = Daily minimum 2-meter air temperature in degrees Celsius.\cr
vp = Water vapor pressure in pascals. Daily average partial pressure of water vapor.\cr}

\item{years}{A numeric vector of years to extract.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NED/".}
}
\value{
A a list of \code{RasterBrick}s---one for each element---cropped within the specified \code{template}.
}
\description{
\code{get_daymet_tile} returns a list of \code{RasterBrick}s---one for each element---cropped within the specified \code{template}.
If template is not provided, returns the entire DAYMET tile.
}
\keyword{internal}

