\name{display.tests}
\alias{display.tests}
\title{Display Full Test Information for Peaks}

\description{
Displays full test information (not just \emph{p}-values) for peaks generated by \code{\link{run.analysis}}.}

\usage{
display.tests(sig.rows = "all", summ = "anova", tests,
              form = parameter.list$form,
              use.model = parameter.list$use.model, ...)
}

\arguments{
    \item{sig.rows}{numeric or character vector used to select rows of \code{sigs}; default value returns all significant tests}
    \item{summ}{either a function or string representing a function which can be applied to the output of \code{use.model} or \code{"none"}}
    \item{tests}{numeric or character vector used to select rows of \code{clust.mat}; default value returns 
        the rows in \code{clust.mat} corresponding to the rows in \code{sigs[sig.rows,]}}
    \item{form}{formula for use in \code{lm}; default is the one that was used to generate the significant peaks}
    \item{use.model}{function or string representing a function; what test to apply to data}
    \item{...}{arguments to be passed to \code{use.model}}
}

\details{
If \code{use.model} in \code{\link{run.analysis}} evaluates to anything other
than \code{\link{t.test}}, then the only thing reported on each peak by
\code{\link{run.analysis}} is the \emph{p}-value.  This program takes a
specified subset of the significant peaks and returns a list consisting of the
models generated by \code{use.model} (if \code{summ = "none"}) or \code{summ}
applied to those models.  Typical values for \code{summ} include
\code{\link{anova}} and \code{\link{summary}}.

Although the program is designed to be used on significant peaks, by defining
\code{tests} directly in the function call, you can access any of the peaks in
\code{clust.mat}.  If \code{tests} is defined in the function call, its value
overrides anything specified by \code{sig.rows}.
}

\value{
A list with components equal to the models or summaries for the requested peaks.
}

\references{}

\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}

\note{
\code{clust.mat} and \code{sig.mat} must be defined in the workspace for this 
program to work---for example, in the results file output by
\code{\link{run.analysis}}.
}

\seealso{
\code{\link{run.analysis}}, \code{\link{anova}}, \code{\link{lm}}, \code{\link{t.test}}
}

\examples{}
