% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIT.R
\name{prediction.errors}
\alias{prediction.errors}
\title{Computes the prediction errors using the trained models.}
\usage{
prediction.errors(models, expression, attribute, weather)
}
\arguments{
\item{models}{A list of trained models for the genes of interest.

    At the moment the collection of trained models returned
    by \code{FIT::train()} cannot be directly passed to \code{FIT::predict()}:
    the user has to explicitly convert it to an appropriate format by using
    \code{FIT::train.to.predict.adaptor()}.
    (This restriction might be removed in a future.)}

\item{expression}{An object that represents the actual measured data of
gene expressions.
The object can be created from a dumped/saved dataframe
of size \code{nsamples * ngenes}
using \code{FIT::load.expression()}.
(At the moment it is an instance of a hidden class IO$Attribute,
but this may be subject to change.)}

\item{attribute}{An object that represents the attributes of
microarray/RNA-seq data.
The object can be created from a dumped/saved dataframe
using \code{FIT::load.attribute()}.
(At the moment it is an instance of a hidden class IO$Attribute,
but this may be subject to change.)}

\item{weather}{An object that represents actual or hypothetical weather data
with which predictions of gene expressions are made.
The object can be created from a dumped/saved dataframe
using \code{FIT::load.weather()}.
(At the moment it is an instance of a hidden class IO$Weather,
but this may be subject to change.)}
}
\value{
A list of deviance (a measure of validity of predictions,
    as is defined by each model) between the prediction results
    and the measured results (as is provided by the user through
    \code{expression} argument).
}
\description{
Computes the prediction errors using the trained models.
}
\examples{
\dontrun{
# see the usage of FIT::predict()
}
}

