% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedLR_fun.R
\name{weighted.LR}
\alias{weighted.LR}
\alias{wLR.AM}
\alias{wLR.GM}
\title{Weighted Lehmann-Romano Procedure}
\usage{
weighted.LR(
  raw.pvalues,
  weights,
  alpha = 0.05,
  zeta = 0.5,
  weighting.method = "AM",
  critical.values = FALSE
)

wLR.AM(raw.pvalues, weights, alpha = 0.05, zeta = 0.5, critical.values = FALSE)

wLR.GM(raw.pvalues, weights, alpha = 0.05, zeta = 0.5, critical.values = FALSE)
}
\arguments{
\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbor in the CDFs supports.}

\item{weights}{a numeric vector. Contains the weights of the p-values.}

\item{alpha}{the target FDP, a number strictly between 0 and 1. For \code{*.fast} kernels, it is only necessary, if \code{stepUp = TRUE}.}

\item{zeta}{the target probability of not exceeding the desired FDP, a number strictly between 0 and 1. If \code{zeta=NULL} (the default), then \code{zeta} is chosen equal to \code{alpha}.}

\item{weighting.method}{a character string specifying whether to conduct arithmetic (\code{direction="AM"}, the default) or geometric weighting (\code{direction="GM"}) of p-values.}

\item{critical.values}{a boolean. If \code{TRUE}, critical constants are computed and returned (this is computationally intensive).}
}
\value{
A \code{FDX} S3 class object whose elements are:
\item{Rejected}{Rejected raw p-values.}
\item{Indices}{Indices of rejected hypotheses.}
\item{Num.rejected}{Number of rejections.}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}
\item{Weighted}{Weighted p-values.}
\item{Critical.values}{Critical values (if requested).}
\item{Method}{A character string describing the used algorithm, e.g. 'Discrete Lehmann-Romano procedure (step-up)'.}
\item{FDP.threshold}{FDP threshold \code{alpha}.}
\item{Exceedance.probability}{Probability \code{zeta} of FDP exceeding \code{alpha}; thus, FDP is being controlled at level \code{alpha} with confidence \code{1 - zeta}.}

\item{Weighting}{A character string describing the weighting method.}
\item{Data$raw.pvalues}{The values of \code{raw.pvalues}.}

\item{Data$weights}{The values of \code{weights}.}
\item{Data$data.name}{The respective variable names of \code{raw.pvalues} and \code{pCDFlist}.}
}
\description{
Apply the weighted [wLR] procedure, with or without computing the
critical values, to a set of p-values. Both arithmetic and geometric
weighting are available.
}
\details{
\code{wLR.AM} and \code{wLR.GM} are wrapper functions for \code{weighted.LR}.
The first one simply passes all its parameters to \code{weighted.LR} with
\code{weighting.method = "AM"} and \code{wLR.GM} does the same with
\code{weighting.method = "GM"}.
}
\examples{
# Construction of the p-values and their supports for weighted methods
raw.pvalues.weighted <- c(0.7389727, 0.1882310, 0.1302457, 0.9513677,
                         0.7592122, 0.0100559, 0.0000027, 0.1651034)
weights <- c(0.7947122, 1.2633867, 2.8097858, 2.2112801,
            2.3878654, 1.2389620, 2.3878654, 0.7947122)

wLR.AM.fast <- wLR.AM(raw.pvalues.weighted, weights)
summary(wLR.AM.fast)

wLR.AM.crit <- wLR.AM(raw.pvalues.weighted, weights, critical.values = TRUE)
summary(wLR.AM.crit)

wLR.GM.fast <- wLR.GM(raw.pvalues.weighted, weights)
summary(wLR.GM.fast)

wLR.GM.crit <- wLR.GM(raw.pvalues.weighted, weights, critical.values = TRUE)
summary(wLR.GM.crit)

}
\seealso{
\code{\link{kernel}}, \code{\link{FDX-package}}, \code{\link{continuous.LR}},
\code{\link{continuous.GR}}, \code{\link{discrete.LR}}, 
\code{\link{discrete.GR}}, \code{\link{discrete.PB}}, 
\code{\link{weighted.GR}}, \code{\link{weighted.PB}}
}
