% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{get_partners}
\alias{get_partners}
\title{Return the Historical Partners (Contacts) of a Set of Index Patients}
\usage{
get_partners(
  dat,
  index_posit_ids,
  networks = NULL,
  truncate = Inf,
  only.active.nodes = FALSE
)
}
\arguments{
\item{dat}{Main list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{index_posit_ids}{The positional IDs of the indexes of interest.}

\item{networks}{Numerical indexes of the networks to extract the partnerships
from. (May be > 1 for models with multiple overlapping
networks.) If \code{NULL}, extract from all networks.}

\item{truncate}{After how many time steps a partnership that is no longer
active should be removed from the output.}

\item{only.active.nodes}{If \code{TRUE}, then inactive (e.g., deceased)
partners will be removed from the output.}
}
\value{
A \code{data.frame} with 5 columns:
\itemize{
\item \code{index}: the unique ID (see \code{get_unique_ids}) of the
indexes.
\item \code{partner}: the unique ID (see \code{get_unique_ids}) of the
partners/contacts.
\item \code{start}: the time step in which the edge started.
\item \code{stop}: the time step in which the edge stopped; if ongoing,
then \code{NA} is returned.
\item \code{network}: the numerical index for the network on which the
partnership/contact is located.
}
}
\description{
Return the Historical Partners (Contacts) of a Set of Index Patients
}
