% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epicurve.R
\name{epicurve}
\alias{epicurve}
\title{Plot the epidemic curve}
\usage{
epicurve(epicounts, dates = NULL,
datelab = c("7d", "1m", "3m", "6m"), seriesname = "Series 1",
themetype = c("gray","classic","light","dark"), colbar = "deepskyblue4",
title = "Epidemic curve", poslegend = "right", dirlegend = "vertical",
xlabel = "Time (days)", ylabel = "Incidence")
}
\arguments{
\item{epicounts}{A time series of counts in data frame format.}

\item{dates}{A vector of dates in format "YY-MM-DD".}

\item{datelab}{The spacing for ticks on the x-axis. Either 7 days, 1 month,
3 months or 6 months.}

\item{seriesname}{The legend name of the time series.}

\item{themetype}{Type of theme for the plot.}

\item{colbar}{The color of the bars.}

\item{title}{Title of the plot.}

\item{poslegend}{The position of the legend in the plot.}

\item{dirlegend}{The direction of the legend in the plot.}

\item{xlabel}{The label on the x-axis.}

\item{ylabel}{The label on the y-axis.}
}
\value{
A plot of the epidemic curve based on the provided time series of
counts.
}
\description{
This routine gives a graphical representation of the epidemic curve based
on incidence data.
}
\examples{
si <- c(0.05, 0.05, 0.1, 0.1, 0.1, 0.1, 0.1, 0.05, 0.05, 0.1, 0.1, 0.1)
epidemic <- episim(serial_interval = si, Rpattern = 4)
epi_inci <- as.data.frame(epidemic$y)
epicurve(epi_inci)
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
