% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPISA_YAFS.R
\name{readPISA_YAFS}
\alias{readPISA_YAFS}
\title{PISA YAFS (Young Adult Follow-up Study)}
\usage{
readPISA_YAFS(
  datPath = file.path(getwd(), "PISA_YAFS2016_Data.dat"),
  spsPath = file.path(getwd(), "PISA_YAFS2016_SPSS.sps"),
  esdf_PISA2012_USA = NULL
)
}
\arguments{
\item{datPath}{a character value of the file location where the data file (.dat) file is saved.}

\item{spsPath}{a character value of the file location where the SPSS (.sps) script file is saved to parse the \code{datPath} data file.}

\item{esdf_PISA2012_USA}{(optional) an \code{edsurvey.data.frame} of the USA PISA 2012 data if planning to analyze the PISA YAFS data alongside the USA PISA 2012 dataset.}
}
\value{
An \code{edsurvey.data.frame} for the PISA YAFS dataset if the \code{esdf_PISA2012_USA} parameter is \code{NULL}.  If the PISA 2012 USA \code{edsurvey.data.frame} is specified for the \code{esdf_PISA2012_USA}
parameter, then the resulting dataset will return an \code{edsurvey.data.frame} allowing analysis for a combined dataset.
}
\description{
Opens a connection to the Programme for International Student Assessment (PISA) YAFS 2016 data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the unzipped files for the PISA YAFS.  The PISA YAFS dataset is a follow-up study of a subset of the students who
participated in the PISA 2012 USA study.  It can be analyzed on its own as a singular dataset or optionally merged with the PISA 2012 USA data, 
in which case there will be two sets of weights in the merged dataset (the default PISA YAFS weights and the PISA 2012 USA weights).
}
\examples{
\dontrun{
#Return an edsurvey.data.frame for only the PISA YAFS dataset.
#Either omit, or set the esdf_PISA2012_USA to a NULL value.
yafs <- readPISA_YAFS(datPath = "~/PISA YAFS/2016/PISA_YAFS2016_Data.dat",
                      spsPath = "~/PISA YAFS/2016/PISA_YAFS2016_SPSS.sps",
                      esdf_PISA2012_USA = NULL)
  
#If wanting to analyze the PISA YAFS dataset in conjunction with the PISA 2012 
#United States of America (USA) dataset, it should be read in first to an edsurvey.data.frame.
#Then pass the resulting edsurvey.data.frame as a parameter for the
#esdf_PISA2012_USA argument. No other edsurvey.data.frames are supported.
usa2012 <- readPISA("~/PISA/2012", database = "INT", countries = "usa")
  
yafs <- readPISA_YAFS(datPath = "~/PISA YAFS/2016/PISA_YAFS2016_Data.dat",
                      spsPath = "~/PISA YAFS/2016/PISA_YAFS2016_SPSS.sps",
                      esdf_PISA2012_USA = usa2012)
head(yafs)
}
}
\seealso{
\code{\link{readPISA}}
}
\author{
Tom Fink
}
