% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNLS72.R
\name{readNLS72}
\alias{readNLS72}
\title{Connect to NLS-72 Study Data}
\usage{
readNLS72(
  NLS7286_PRI_FilePath,
  NLS7286_SASSyntax_Path,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{NLS7286_PRI_FilePath}{a character value to the main study derived
analyticial data file (NLS7286_REV.PRI).
Located within the \code{REVISED_ASCII} folder.}

\item{NLS7286_SASSyntax_Path}{a character value to the SAS syntax file for
parsing the \code{NLS7286_REV.PRI} data file.
Located within the \code{SAS_EXTRACT_LOGIC} folder.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read
function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output
while the \code{readNLS72} function is running to
indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the National Longitudinal Study of the
High School Class of 1972 longitudinal dataset
}
\description{
Opens a connection to a National Longitudinal Study of the High
             School Class of 1972 (NLS-72) cohort data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the specified \code{NLS7286_SASSyntax_Path} file to parse
         the \code{NLS7286_PRI_FilePath} file.
         A cached data file and metadata file will be saved in the same
         directory and filename as the \code{NLS7286_PRI_FilePath} file,
         having new file extensions of .csv and .meta, respectively.
}
\seealso{
\code{\link{readHSB_Sophomore}}, \code{\link{readHSB_Senior}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
