% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNAEP.r
\name{readNAEP}
\alias{readNAEP}
\title{Connect to NAEP Data}
\usage{
readNAEP(
  path,
  defaultWeight = "origwt",
  defaultPvs = "composite",
  omittedLevels = c("Multiple", NA, "Omitted"),
  frPath = NULL
)
}
\arguments{
\item{path}{a character value indicating the full filepath location and name
of the (.dat) data file}

\item{defaultWeight}{a character value that indicates the default weight
specified in the resulting \code{edsurvey.data.frame}.  
Default value is \code{origwt} if not specified.}

\item{defaultPvs}{a character value that indicates the default plausible value
specified in the resulting \code{edsurvey.data.frame}.
Default value is \code{composite} if not specified.}

\item{omittedLevels}{a character vector indicating which factor levels/labels
should be excluded. When set to the default value of
\code{c('Multiple',NA,'Omitted')}, adds the vector to
the \code{edsurvey.data.frame}.}

\item{frPath}{a character value indicating the location of the \code{fr2}
parameter layout file included with the data companion to
parse the specified \code{filepath} data file}
}
\value{
An \code{edsurvey.data.frame} containing the following elements:
   \item{userConditions}{a list containing all user conditions set using the \code{subset.edsurvey.data.frame} method}
   \item{defaultConditions}{the default conditions to be applied to the \code{edsurvey.data.frame}}
   \item{data}{an \code{LaF} object containing a connection to the student dataset on disk}
   \item{dataSch}{an \code{LaF} object containing a connection to the school dataset on disk}
   \item{dataTch}{not applicable for NAEP data; returns \code{NULL}}
   \item{weights}{a list containing the weights found on the \code{edsurvey.data.frame}}
   \item{pvvar}{a list containing the plausible values found on the \code{edsurvey.data.frame}}
   \item{subject}{the subject of the dataset contained in the \code{edsurvey.data.frame}}
   \item{year}{the year of assessment of the dataset contained in the \code{edsurvey.data.frame}}
   \item{assessmentCode}{the code of the dataset contained in the \code{edsurvey.data.frame}}
   \item{dataType}{the type of data (whether student or school) contained in the \code{edsurvey.data.frame}}
   \item{gradeLevel}{the grade of the dataset contained in the \code{edsurvey.data.frame}}
   \item{achievementLevels}{default NAEP achievement cutoff scores}
   \item{omittedLevels}{the levels of the factor variables that will be omitted from the \code{edsurvey.data.frame}}
   \item{fileFormat}{a \code{data.frame} containing the parsed information from the student .fr2 file associated with the data}
   \item{fileFormatSchool}{a \code{data.frame} containing the parsed information from the school .fr2 file associated with the data}
   \item{fileFormatTeacher}{not applicable for NAEP data; returns \code{NULL}}
   \item{survey}{the type of survey data contained in the \code{edsurvey.data.frame}}
}
\description{
Opens a connection to an NAEP data file residing
             on the disk and returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
The function uses the \code{frPath} file layout (.fr2) data to read in the
fixed-width data file (.dat) and builds the \code{edsurvey.data.frame}.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
sdf

\dontrun{
# To read in an NCES file first set the directory to the ~/Data subfolder,
# then read in the appropriate .dat file:
setwd("location/of/Data")
sdf <- readNAEP(path="M36NT2PM.dat")

# Or read in the .dat file directly through the folder pathway:
sdf <- readNAEP(path="location/of/Data/M36NT2PM.dat")
}
}
\author{
Tom Fink and Ahmad Emad
}
